/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.menusystem.menus.settings;

import java.util.ArrayList;
import java.util.HashMap;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.devices.components.MouseButtons;
import org.jagatoo.input.managers.InputBindingsManager;
import org.jagatoo.input.managers.InputBindingsSet;
import org.openmali.vecmath2.Colorf;
import org.xith3d.input.FirstPersonInputHandler;
import org.xith3d.input.modules.fpih.FPIHInputAction;
import org.xith3d.input.modules.fpih.FPIHInputBindingsManager;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.borders.ColoredBorder;
import org.xith3d.ui.hud.layout.FillLayout;
import org.xith3d.ui.hud.layout.GridLayout;
import org.xith3d.ui.hud.layout.LayoutManager;
import org.xith3d.ui.hud.listeners.WidgetInputAdapter;
import org.xith3d.ui.hud.listeners.WidgetInputListener;
import org.xith3d.ui.hud.listeners.WidgetMouseAdapter;
import org.xith3d.ui.hud.listeners.WidgetMouseListener;
import org.xith3d.ui.hud.menusystem.menus.MenuBase;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.Panel;
import org.xith3d.ui.text2d.TextAlignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FPIHInputBindingsSettingsMenu
extends MenuBase {
    public static final String NAME = FPIHInputBindingsSettingsMenu.class.getSimpleName();
    private final HashMap<FPIHInputAction, Label[]> actionLabelMap = new HashMap();
    private final HashMap<Label, FPIHInputAction> labelActionMap = new HashMap();
    private final InputBindingsManager<FPIHInputAction> inputBindings = new InputBindingsManager(FPIHInputAction.values().length);
    private Label bindingQuery;
    private Label lastClickedLabel = null;
    private WidgetInputListener bindingSetListener = new WidgetInputAdapter(){

        private final void handleInput(DeviceComponent comp) {
            FPIHInputBindingsSettingsMenu.this.bindingQuery.removeInputListener(FPIHInputBindingsSettingsMenu.this.bindingSetListener);
            if (FPIHInputBindingsSettingsMenu.this.lastClickedLabel == null) {
                return;
            }
            FPIHInputBindingsSettingsMenu.this.bindingQuery.setClickable(false);
            FPIHInputBindingsSettingsMenu.this.bindingQuery.setPickable(false);
            FPIHInputBindingsSettingsMenu.this.bindingQuery.setVisible(false);
            FPIHInputAction action = (FPIHInputAction)FPIHInputBindingsSettingsMenu.this.labelActionMap.get(FPIHInputBindingsSettingsMenu.this.lastClickedLabel);
            FPIHInputBindingsSettingsMenu.this.setBinding(comp, action, (InputBindingsSet)((Object)FPIHInputBindingsSettingsMenu.this.lastClickedLabel.getUserObject()));
            FPIHInputBindingsSettingsMenu.this.getMenuGroup().fireOnSettingChanged(FPIHInputBindingsSettingsMenu.this, "key_binding", comp.getName() + "=>" + action);
            FPIHInputBindingsSettingsMenu.this.lastClickedLabel = null;
        }

        public void onKeyPressed(Widget widget, Key key, int modifierMask, long when) {
            this.handleInput(key);
        }

        public void onMouseWheelMoved(Widget widget, int delta, boolean isPageMove, float x, float y, long when, boolean isTopMost) {
            if (delta > 0) {
                this.handleInput(MouseButtons.WHEEL_UP);
            } else if (delta < 0) {
                this.handleInput(MouseButtons.WHEEL_DOWN);
            }
        }
    };
    private WidgetMouseListener bindingInputListener = new WidgetMouseAdapter(){

        public void onMouseButtonReleased(Widget widget, MouseButton button, float x, float y, long when, long lastWhen, boolean isTopMost, boolean hasFocus) {
            FPIHInputBindingsSettingsMenu.this.lastClickedLabel = (Label)widget;
            if (lastWhen != -1L && when - lastWhen < 300000000L) {
                float parentLeft = 0.0f;
                float parentTop = 0.0f;
                float parentResX = 0.0f;
                float parentResY = 0.0f;
                if (widget.getContainer() != null) {
                    parentLeft = widget.getContainer().getLeft();
                    parentTop = widget.getContainer().getTop();
                    parentResX = widget.getContainer().getResX();
                    parentResY = widget.getContainer().getResY();
                } else if (widget.getHUD() != null) {
                    parentResX = widget.getHUD().getResX();
                    parentResY = widget.getHUD().getResY();
                }
                FPIHInputBindingsSettingsMenu.this.bindingQuery.setLocation(parentLeft + 2.0f, parentTop + 2.0f);
                FPIHInputBindingsSettingsMenu.this.bindingQuery.setSize(parentResX - 4.0f, parentResY - 4.0f);
                FPIHInputBindingsSettingsMenu.this.bindingQuery.setClickable(true);
                FPIHInputBindingsSettingsMenu.this.bindingQuery.setPickable(true);
                FPIHInputBindingsSettingsMenu.this.bindingQuery.setVisible(true);
                FPIHInputBindingsSettingsMenu.this.bindingQuery.setFocussable(true);
                FPIHInputBindingsSettingsMenu.this.bindingQuery.requestFocus();
                FPIHInputBindingsSettingsMenu.this.bindingQuery.addInputListener(FPIHInputBindingsSettingsMenu.this.bindingSetListener);
            }
        }
    };
    private ArrayList<Widget> earlyWidgets;

    public void setBinding(DeviceComponent comp, FPIHInputAction action, InputBindingsSet set) {
        FPIHInputAction bound = this.inputBindings.getBoundAction(comp);
        if (bound != null) {
            Label[] boundLabels = this.actionLabelMap.get(bound);
            if (boundLabels[0].getText().equals(comp.getName())) {
                boundLabels[0].setText("");
            } else if (boundLabels[1].getText().equals(comp.getName())) {
                boundLabels[1].setText("");
            }
        }
        Label targetLabel = set == InputBindingsSet.PRIMARY ? this.actionLabelMap.get(action)[0] : this.actionLabelMap.get(action)[1];
        this.inputBindings.bind(comp, action, set);
        targetLabel.setText(comp.getLocalizedName());
    }

    public void resetBinding(FPIHInputAction action, InputBindingsSet set) {
        if (this.inputBindings.unbind(action) != null) {
            Label targetLabel = set == InputBindingsSet.PRIMARY ? this.actionLabelMap.get(action)[0] : this.actionLabelMap.get(action)[1];
            targetLabel.setText("");
        }
    }

    public FPIHInputAction getBinding(DeviceComponent comp) {
        return this.inputBindings.getBoundAction(comp);
    }

    public DeviceComponent getBoundComponent(FPIHInputAction action, InputBindingsSet set) {
        return this.inputBindings.getBoundComponent(action, set);
    }

    public void clearBindings() {
        this.inputBindings.unbindAll();
        for (Label label : this.labelActionMap.keySet()) {
            label.setText("");
        }
    }

    public void setBindings(InputBindingsManager<FPIHInputAction> inputBindings) {
        this.clearBindings();
        for (FPIHInputAction action : FPIHInputAction.values()) {
            for (InputBindingsSet set : InputBindingsSet.values()) {
                DeviceComponent comp = inputBindings.getBoundComponent(action, set);
                if (comp == null) continue;
                this.setBinding(comp, action, set);
            }
        }
    }

    public InputBindingsManager<FPIHInputAction> getBindings() {
        return this.inputBindings;
    }

    public void applyConfig(FirstPersonInputHandler fpih) {
        this.setBindings(fpih.getBindingsManager());
    }

    public void extractConfig(FirstPersonInputHandler fpih, boolean clearFPIHBefore) {
        fpih.getBindingsManager().set(this.inputBindings, clearFPIHBefore);
    }

    @Override
    protected void initWidgets() {
        if (this.earlyWidgets != null) {
            for (int i = 0; i < this.earlyWidgets.size(); ++i) {
                this.addWidget(this.earlyWidgets.get(i));
            }
            this.earlyWidgets = null;
        }
    }

    private Panel createMiniPanel(float height, int borderBottom, int borderRight, int borderTop, int borderLeft, Colorf backgroundColor) {
        Panel panel = new Panel(200.0f, height, backgroundColor);
        panel.setLayout(new FillLayout());
        panel.setBorder(new ColoredBorder(borderBottom, borderRight, borderTop, borderLeft, Colorf.DARK_GRAY));
        return panel;
    }

    private void addHeaderLine(HUDFont font) {
        Panel panel1 = this.createMiniPanel(30.0f, 1, 1, 1, 1, null);
        Label label1 = new Label(0.0f, 0.0f, "Command", font, Colorf.BLACK, TextAlignment.CENTER_LEFT);
        label1.setPadding(0, 3, 0, 3);
        panel1.addWidget(label1);
        this.earlyWidgets.add(panel1);
        Panel panel2 = this.createMiniPanel(30.0f, 1, 1, 1, 0, null);
        Label label2 = new Label(0.0f, 0.0f, "Key 1", font, Colorf.BLACK, TextAlignment.CENTER_CENTER);
        panel2.addWidget(label2);
        this.earlyWidgets.add(panel2);
        Panel panel3 = this.createMiniPanel(30.0f, 1, 1, 1, 0, null);
        Label label3 = new Label(0.0f, 0.0f, "Key 2", font, Colorf.BLACK, TextAlignment.CENTER_CENTER);
        panel3.addWidget(label3);
        this.earlyWidgets.add(panel3);
        Panel panel4 = this.createMiniPanel(5.0f, 0, 1, 0, 1, null);
        this.earlyWidgets.add(panel4);
        Panel panel5 = this.createMiniPanel(5.0f, 0, 1, 0, 0, null);
        this.earlyWidgets.add(panel5);
        Panel panel6 = this.createMiniPanel(5.0f, 0, 1, 0, 0, null);
        this.earlyWidgets.add(panel6);
    }

    private void addBindingLine(String caption, FPIHInputAction action, HUDFont font) {
        int borderTop = this.actionLabelMap.size() == 0 ? 1 : 0;
        Panel panel1 = this.createMiniPanel(30.0f, 1, 1, borderTop, 1, null);
        Label label1 = new Label(1.0f, 1.0f, caption, font, Colorf.BLACK, TextAlignment.CENTER_LEFT);
        label1.setPadding(0, 3, 0, 3);
        panel1.addWidget(label1);
        this.earlyWidgets.add(panel1);
        Panel panel2 = this.createMiniPanel(30.0f, 1, 1, borderTop, 0, Colorf.BLACK);
        Label label2 = new Label(1.0f, 1.0f, "", font, Colorf.WHITE, TextAlignment.CENTER_CENTER);
        label2.setUserObject((Object)InputBindingsSet.PRIMARY);
        label2.addMouseListener(this.bindingInputListener);
        panel2.addWidget(label2);
        this.earlyWidgets.add(panel2);
        Panel panel3 = this.createMiniPanel(30.0f, 1, 1, borderTop, 0, Colorf.BLACK);
        Label label3 = new Label(1.0f, 1.0f, "", font, Colorf.WHITE, TextAlignment.CENTER_CENTER);
        label3.setUserObject((Object)InputBindingsSet.SECONDARY);
        label3.addMouseListener(this.bindingInputListener);
        panel3.addWidget(label3);
        this.earlyWidgets.add(panel3);
        this.actionLabelMap.put(action, new Label[]{label2, label3});
        this.labelActionMap.put(label2, action);
        this.labelActionMap.put(label3, action);
    }

    public FPIHInputBindingsSettingsMenu(float width, float height) {
        super(width, height, NAME, new String[]{"save"});
        this.setLayout(new GridLayout(0, 3, 0.0f, 0.0f, 10.0f, 10.0f, 10.0f, 10.0f));
        HUDFont font = HUDFont.getFont("Verdana", HUDFont.PLAIN, 12);
        this.earlyWidgets = new ArrayList();
        this.addHeaderLine(font.derive(HUDFont.BOLD));
        this.addBindingLine(FPIHInputAction.WALK_FORWARD.getLocalizedText(), FPIHInputAction.WALK_FORWARD, font);
        this.addBindingLine(FPIHInputAction.WALK_BACKWARD.getLocalizedText(), FPIHInputAction.WALK_BACKWARD, font);
        this.addBindingLine(FPIHInputAction.STRAFE_LEFT.getLocalizedText(), FPIHInputAction.STRAFE_LEFT, font);
        this.addBindingLine(FPIHInputAction.STRAFE_RIGHT.getLocalizedText(), FPIHInputAction.STRAFE_RIGHT, font);
        this.addBindingLine(FPIHInputAction.TURN_LEFT.getLocalizedText(), FPIHInputAction.TURN_LEFT, font);
        this.addBindingLine(FPIHInputAction.TURN_RIGHT.getLocalizedText(), FPIHInputAction.TURN_RIGHT, font);
        this.addBindingLine(FPIHInputAction.AIM_UP.getLocalizedText(), FPIHInputAction.AIM_UP, font);
        this.addBindingLine(FPIHInputAction.AIM_DOWN.getLocalizedText(), FPIHInputAction.AIM_DOWN, font);
        this.addBindingLine(FPIHInputAction.JUMP.getLocalizedText(), FPIHInputAction.JUMP, font);
        this.addBindingLine(FPIHInputAction.CROUCH.getLocalizedText(), FPIHInputAction.CROUCH, font);
        this.addBindingLine(FPIHInputAction.DISCRETE_ZOOM_IN.getLocalizedText(), FPIHInputAction.DISCRETE_ZOOM_IN, font);
        this.addBindingLine(FPIHInputAction.DISCRETE_ZOOM_OUT.getLocalizedText(), FPIHInputAction.DISCRETE_ZOOM_OUT, font);
        this.addBindingLine(FPIHInputAction.ZOOM_IN.getLocalizedText(), FPIHInputAction.ZOOM_IN, font);
        this.addBindingLine(FPIHInputAction.ZOOM_OUT.getLocalizedText(), FPIHInputAction.ZOOM_OUT, font);
        this.bindingQuery = new Label(0.0f, 0.0f, "PRESS_KEY", font.derive(HUDFont.BOLD), Colorf.GREEN, TextAlignment.CENTER_CENTER);
        this.bindingQuery.setZIndex(10);
        this.bindingQuery.setBackgroundColor(Colorf.BLACK);
        this.addWidget((Widget)this.bindingQuery, 100.0f, 100.0f, LayoutManager.IGNORED_BY_LAYOUT);
        this.bindingQuery.setVisible(false);
        this.bindingQuery.setClickable(false);
        this.bindingQuery.setPickable(false);
        this.setBindings(FPIHInputBindingsManager.DEFAULT_BINDINGS);
    }

    public FPIHInputBindingsSettingsMenu(float width) {
        this(width, 0.0f);
        this.setMinimalHeight();
    }
}

