/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.utils;

import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.scenegraph.TextureImage2D;

public class HUDTextureUtils {
    public static final int getTextureWidth(TextureImage2D texture, boolean isDrawTexture) {
        if (isDrawTexture) {
            return texture.getOriginalWidth();
        }
        return texture.getWidth();
    }

    public static final int getTextureHeight(TextureImage2D texture, boolean isDrawTexture) {
        if (isDrawTexture) {
            return texture.getOriginalHeight();
        }
        return texture.getHeight();
    }

    public static final int getTextureWidth(Texture2D texture) {
        return HUDTextureUtils.getTextureWidth(texture.getImage0(), texture.isDrawTexture());
    }

    public static final int getTextureHeight(Texture2D texture) {
        return HUDTextureUtils.getTextureHeight(texture.getImage0(), texture.isDrawTexture());
    }

    public static final Texture2D getTexture(String textureName, boolean useCache) {
        if (textureName == null) {
            return null;
        }
        return TextureLoader.getInstance().getTexture(textureName, null, null, Texture.MipmapMode.BASE_LEVEL, false, useCache, true);
    }

    public static final Texture2D getTexture(String textureName) {
        return HUDTextureUtils.getTexture(textureName, true);
    }

    public static final Texture2D getTextureOrNull(String textureName, boolean useCache) {
        Texture2D texture = HUDTextureUtils.getTexture(textureName, useCache);
        if (TextureLoader.isFallbackTexture(texture)) {
            return null;
        }
        return texture;
    }

    public static final Texture2D getTextureOrNull(String textureName) {
        return HUDTextureUtils.getTextureOrNull(textureName, true);
    }
}

