/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.widgets;

import org.openmali.types.twodee.Dim2i;
import org.openmali.types.twodee.Rect2i;
import org.openmali.vecmath2.Tuple2i;
import org.xith3d.render.RenderPassConfig;
import org.xith3d.scenegraph.Texture2DCanvas;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.Widget;
import org.xith3d.ui.hud.base.Window;
import org.xith3d.ui.hud.listeners.WidgetLocationAdapter;
import org.xith3d.ui.hud.listeners.WidgetLocationListener;

public class Widget3D
extends Widget {
    private final RenderPassConfig rpConfig;
    private final WidgetLocationListener windowLocationListener;

    public final RenderPassConfig getRenderPassConfig() {
        return this.rpConfig;
    }

    protected void applyLocationToRenderPass(float x, float y) {
        Tuple2i loc2 = Tuple2i.fromPool();
        if (this.getBorder() != null) {
            x += (float)this.getBorder().getLeftWidth();
            y += (float)this.getBorder().getTopHeight();
        }
        this.getLocationHUD2Pixels_(x, y, loc2);
        Rect2i viewport = this.rpConfig.getViewport();
        if (viewport == null) {
            viewport = new Rect2i();
            this.rpConfig.setViewport(viewport);
        }
        viewport.setLocation(loc2.getX(), loc2.getY());
        Tuple2i.toPool(loc2);
    }

    protected void applySizeToRenderPass(float w, float h) {
        Dim2i size2 = Dim2i.fromPool();
        if (this.getBorder() != null) {
            w -= (float)(this.getBorder().getLeftWidth() + this.getBorder().getRightWidth());
            h -= (float)(this.getBorder().getTopHeight() + this.getBorder().getBottomHeight());
        }
        this.getSizeHUD2Pixels_(w, h, size2);
        Rect2i viewport = this.rpConfig.getViewport();
        if (viewport == null) {
            viewport = new Rect2i();
            this.rpConfig.setViewport(viewport);
        }
        viewport.setSize(size2.getWidth(), size2.getHeight());
        Dim2i.toPool(size2);
    }

    protected void onAttachedToHUD(HUD hud) {
        super.onAttachedToHUD(hud);
        this.applyLocationToRenderPass(this.getLeft(), this.getTop());
        this.applySizeToRenderPass(this.getWidth(), this.getHeight());
        Window w = this.getParentWindow();
        if (w != null) {
            w.addLocationListener(this.windowLocationListener);
        }
    }

    protected void onDetachedFromHUD(HUD hud) {
        super.onDetachedFromHUD(hud);
        Window w = this.getParentWindow();
        if (w != null) {
            w.addLocationListener(this.windowLocationListener);
        }
    }

    protected void onLocationChanged(float oldLeft, float oldTop, float newLeft, float newTop) {
        super.onLocationChanged(oldLeft, oldTop, newLeft, newTop);
        if (this.getHUD() != null) {
            this.applyLocationToRenderPass(newLeft, newTop);
        }
    }

    protected void onSizeChanged(float oldWidth, float oldHeight, float newWidth, float newHeight) {
        super.onSizeChanged(oldWidth, oldHeight, newWidth, newHeight);
        if (this.getHUD() != null) {
            this.applySizeToRenderPass(newWidth, newHeight);
        }
    }

    protected void drawWidget(Texture2DCanvas texCanvas, int offsetX, int offsetY, int width, int height, boolean drawsSelf) {
    }

    protected void init() {
    }

    public Widget3D(float width, float height, RenderPassConfig rpConfig) {
        super(false, false, width, height);
        this.rpConfig = rpConfig;
        this.windowLocationListener = new WidgetLocationAdapter(){

            public void onWidgetLocationChanged(Widget widget, float oldLeft, float oldTop, float newLeft, float newTop) {
                Widget3D.this.applyLocationToRenderPass(Widget3D.this.getLeft(), Widget3D.this.getTop());
            }
        };
    }
}

