/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.hud.widgets.assemblies;

import org.openmali.types.twodee.Dim2f;
import org.openmali.types.twodee.Sized2fRO;
import org.openmali.types.twodee.Sized2iRO;
import org.openmali.vecmath2.Colorf;
import org.xith3d.loop.RenderLoopController;
import org.xith3d.render.RenderPass;
import org.xith3d.resources.LoadingScreenUpdater;
import org.xith3d.resources.ProgressValueSource;
import org.xith3d.resources.ResourceLoader;
import org.xith3d.resources.ResourceLoaderListener;
import org.xith3d.resources.ResourceRequest;
import org.xith3d.scenegraph.Texture2D;
import org.xith3d.ui.hud.HUD;
import org.xith3d.ui.hud.base.WidgetContainer;
import org.xith3d.ui.hud.utils.HUDFont;
import org.xith3d.ui.hud.utils.HUDTextureUtils;
import org.xith3d.ui.hud.widgets.Image;
import org.xith3d.ui.hud.widgets.Label;
import org.xith3d.ui.hud.widgets.ProgressBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadingScreen
implements LoadingScreenUpdater,
ProgressValueSource,
ResourceLoaderListener {
    private Image backgroundImage = null;
    private Label captionLabel = null;
    private ProgressBar progressBar;
    private RenderLoopController renderLoopController = null;

    public void setRenderLoopController(RenderLoopController rlc) {
        this.renderLoopController = rlc;
    }

    public RenderLoopController getRenderLoopController() {
        return this.renderLoopController;
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public Label getCaptionLabel() {
        return this.captionLabel;
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public HUD getHUD() {
        return this.progressBar.getHUD();
    }

    public RenderPass getRenderPass() {
        return this.getHUD().getRenderPass();
    }

    @Override
    public int getProgressValue() {
        if (this.progressBar == null) {
            throw new NullPointerException("The ProgressBar Widget is invalid");
        }
        return this.progressBar.getValue();
    }

    @Override
    public int getMaxProgressValue() {
        if (this.progressBar == null) {
            throw new NullPointerException("The ProgressBar Widget is invalid");
        }
        return this.progressBar.getMaxValue();
    }

    public String getProgressCaption() {
        if (this.captionLabel == null) {
            throw new NullPointerException("The caption label Widget is invalid");
        }
        return this.captionLabel.getText();
    }

    public void attach(WidgetContainer container) {
        if (this.backgroundImage != null) {
            container.addWidget(this.backgroundImage);
        }
        container.addWidget(this.progressBar, (container.getResX() - this.progressBar.getWidth()) / 2.0f, (container.getResY() - this.progressBar.getHeight()) / 2.0f);
        if (this.captionLabel != null) {
            float labelLocX = this.progressBar.getLeft();
            float labelLocY = this.progressBar.getTop() - this.progressBar.getHeight() * 0.1f - this.captionLabel.getHeight();
            container.addWidget(this.captionLabel, labelLocX, labelLocY);
        }
    }

    public void detach() {
        HUD hud = this.progressBar.getHUD();
        if (this.backgroundImage != null && this.backgroundImage.getContainer() != null) {
            this.backgroundImage.detach();
        }
        if (this.progressBar != null && this.progressBar.getContainer() != null) {
            this.progressBar.detach();
        }
        if (this.captionLabel != null && this.captionLabel.getContainer() != null) {
            this.captionLabel.detach();
        }
        if (hud != null) {
            hud.detach();
        }
    }

    @Override
    public void init(int maxValue, String caption, Texture2D backgroundTexture) {
        if (maxValue >= 0) {
            this.getProgressBar().setMaxValue(maxValue);
        } else if (maxValue < 0 && this.getProgressBar().getMaxValue() < -maxValue) {
            this.getProgressBar().setMaxValue(-maxValue);
        }
        if (caption != null && this.captionLabel != null) {
            this.captionLabel.setText(caption);
        }
        if (backgroundTexture != null && this.backgroundImage != null) {
            this.backgroundImage.setTexture(backgroundTexture);
        }
        if (this.renderLoopController != null) {
            this.renderLoopController.nextFrame();
        }
    }

    @Override
    public final void init(int maxValue, String caption, String backgroundTexture) {
        this.init(maxValue, caption, HUDTextureUtils.getTextureOrNull(backgroundTexture, true));
    }

    protected void updateContent(int value, int maxValue, String caption, Texture2D backgroundTexture) {
        if (this.progressBar != null) {
            this.progressBar.setValue(value);
        }
        if (caption != null && this.captionLabel != null) {
            this.captionLabel.setText(caption);
        }
        if (backgroundTexture != null && this.backgroundImage != null) {
            this.backgroundImage.setTexture(backgroundTexture);
        }
    }

    @Override
    public void update(int incValue, String caption, Texture2D backgroundTexture) {
        this.updateContent(this.getProgressValue() + incValue, this.progressBar.getMaxValue(), caption, backgroundTexture);
        if (this.renderLoopController != null) {
            this.renderLoopController.nextFrame();
        }
    }

    @Override
    public final void update(int incValue, Texture2D backgroundTexture) {
        this.update(incValue, (String)null, backgroundTexture);
    }

    @Override
    public final void update(Texture2D backgroundTexture) {
        this.update(1, (String)null, backgroundTexture);
    }

    @Override
    public final void updateOnly(Texture2D backgroundTexture) {
        this.update(0, (String)null, backgroundTexture);
    }

    @Override
    public final void update(int incValue, String caption, String backgroundTexture) {
        this.update(incValue, caption, HUDTextureUtils.getTexture(backgroundTexture, true));
    }

    @Override
    public final void update(int incValue, String caption) {
        this.update(incValue, caption, (Texture2D)null);
    }

    @Override
    public final void update(int incValue) {
        this.update(incValue, (String)null, (Texture2D)null);
    }

    @Override
    public final void updateOnly(String caption) {
        this.update(0, caption, (Texture2D)null);
    }

    @Override
    public final void update(String caption) {
        this.update(1, caption, (Texture2D)null);
    }

    @Override
    public final void update() {
        this.update(1, (String)null, (Texture2D)null);
    }

    @Override
    public void beforeAnyResourceLoaded(ResourceLoader resLoader) {
    }

    @Override
    public void beforeResourceBundleLoaded(ResourceLoader resLoader, Class<? extends ResourceRequest> bundleType) {
    }

    @Override
    public void afterResourceBundleLoaded(ResourceLoader resLoader, Class<? extends ResourceRequest> bundleType) {
    }

    @Override
    public void beforeResourceLoaded(ResourceLoader resLoader, ResourceRequest request) {
    }

    @Override
    public void afterResourceLoaded(ResourceLoader resLoader, ResourceRequest request, Object resource) {
    }

    @Override
    public void afterAllResourceLoaded(ResourceLoader resLoader) {
    }

    public LoadingScreen(float width, float height, Texture2D backgroundTexture, ProgressBar.Description pbDesc, int maxValue, Label.Description labelDesc, String initialCaption) {
        if (backgroundTexture != null) {
            this.backgroundImage = new Image(width, height, backgroundTexture);
        }
        float pbWidth = width * 0.8f;
        float pbHeight = height * 0.075f;
        if (pbDesc == null) {
            pbDesc = HUD.getTheme().getProgressBarDescription();
        }
        this.progressBar = new ProgressBar(true, pbWidth, pbHeight, 0, maxValue, pbDesc);
        if (labelDesc == null) {
            labelDesc = HUD.getTheme().getLabelDescription();
            labelDesc.setFont(labelDesc.getFont(false).derive(HUDFont.FontStyle.BOLD, 24), false);
            labelDesc.setFontColor(Colorf.WHITE, false);
        }
        this.captionLabel = new Label(true, pbWidth, pbHeight, initialCaption, labelDesc);
    }

    public LoadingScreen(float width, float height, String backgroundTexture, ProgressBar.Description pbDesc, int maxValue, Label.Description labelDesc, String initialCaption) {
        this(width, height, backgroundTexture != null ? HUDTextureUtils.getTexture(backgroundTexture, true) : null, pbDesc, maxValue, labelDesc, initialCaption);
    }

    public LoadingScreen(Sized2fRO size, Texture2D backgroundTexture, ProgressBar.Description pbDesc, int maxValue, Label.Description labelDesc, String initialCaption) {
        this(size.getWidth(), size.getHeight(), backgroundTexture, pbDesc, maxValue, labelDesc, initialCaption);
    }

    public LoadingScreen(Sized2fRO size, String backgroundTexture, ProgressBar.Description pbDesc, int maxValue, Label.Description labelDesc, String initialCaption) {
        this(size, backgroundTexture != null ? HUDTextureUtils.getTexture(backgroundTexture, true) : null, pbDesc, maxValue, labelDesc, initialCaption);
    }

    public LoadingScreen(float width, float height, Texture2D backgroundTexture, int maxValue, String initialCaption) {
        this((Sized2fRO)new Dim2f(width, height), backgroundTexture, (ProgressBar.Description)null, maxValue, (Label.Description)null, initialCaption);
    }

    public LoadingScreen(float width, float height, String backgroundTexture, int maxValue, String initialCaption) {
        this((Sized2fRO)new Dim2f(width, height), backgroundTexture != null ? HUDTextureUtils.getTexture(backgroundTexture, true) : null, (ProgressBar.Description)null, maxValue, (Label.Description)null, initialCaption);
    }

    public static LoadingScreen createWithHUD(Sized2iRO canvas, Texture2D backgroundTexture, ProgressBar.Description pbDesc, int maxValue, Label.Description labelDesc, String initialCaption) {
        HUD hud = new HUD(canvas);
        LoadingScreen ls = new LoadingScreen(hud.getResX(), hud.getResY(), backgroundTexture, pbDesc, maxValue, labelDesc, initialCaption);
        ls.attach(hud.getContentPane());
        return ls;
    }

    public static LoadingScreen createWithHUD(Sized2iRO canvas, String backgroundTexture, ProgressBar.Description pbDesc, int maxValue, Label.Description labelDesc, String initialCaption) {
        HUD hud = new HUD(canvas);
        LoadingScreen ls = new LoadingScreen(hud.getResX(), hud.getResY(), backgroundTexture, pbDesc, maxValue, labelDesc, initialCaption);
        ls.attach(hud.getContentPane());
        return ls;
    }

    public static LoadingScreen createWithHUD(Sized2iRO canvas, Texture2D backgroundTexture, int maxValue, String initialCaption) {
        HUD hud = new HUD(canvas);
        LoadingScreen ls = new LoadingScreen(hud.getResX(), hud.getResY(), backgroundTexture, (ProgressBar.Description)null, maxValue, (Label.Description)null, initialCaption);
        ls.attach(hud.getContentPane());
        return ls;
    }

    public static LoadingScreen createWithHUD(Sized2iRO canvas, String backgroundTexture, int maxValue, String initialCaption) {
        HUD hud = new HUD(canvas);
        LoadingScreen ls = new LoadingScreen(hud.getResX(), hud.getResY(), backgroundTexture, (ProgressBar.Description)null, maxValue, (Label.Description)null, initialCaption);
        ls.attach(hud.getContentPane());
        return ls;
    }

    public static LoadingScreen createWithHUD(Sized2iRO canvas, Texture2D backgroundTexture, int maxValue) {
        return LoadingScreen.createWithHUD(canvas, backgroundTexture, maxValue, "");
    }

    public static LoadingScreen createWithHUD(Sized2iRO canvas, String backgroundTexture, int maxValue) {
        return LoadingScreen.createWithHUD(canvas, backgroundTexture, maxValue, "");
    }
}

