/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.swingui;

import java.awt.Rectangle;
import org.xith3d.scenegraph.Appearance;
import org.xith3d.scenegraph.Material;
import org.xith3d.scenegraph.QuadArray;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.ui.swingui.UIOverlay;
import org.xith3d.utility.logging.X3DLog;

public class UISubOverlayBase {
    protected static final Boolean DEBUG = null;
    protected static final boolean GRID = false;
    protected final int lx;
    protected final int ly;
    protected final int ux;
    protected final int uy;
    protected final int texWidth;
    protected final int texHeight;
    protected final int width;
    protected final int height;
    protected Shape3D shape;
    protected Appearance ap;
    protected UIOverlay overlay;
    protected Rectangle bounds;
    protected boolean dirty;

    protected Rectangle getBounds() {
        return this.bounds;
    }

    protected static int smallestPower(int value) {
        int n;
        for (n = 2; n < value; n *= 2) {
        }
        return n;
    }

    protected void buildShape() {
        float texX = (float)this.width / (float)this.texWidth;
        float texY = (float)this.height / (float)this.texHeight;
        float texLX = 0.0f;
        float texLY = 0.0f;
        X3DLog.debug("  sub overlay texX=", Float.valueOf(texX), ", texY=", Float.valueOf(texY));
        float highOffset = 1.0f;
        float lowOffset = 0.0f;
        float[] verts = new float[]{(float)this.ux + highOffset, (float)this.ly + lowOffset, 0.0f, (float)this.ux + highOffset, (float)this.uy + highOffset, 0.0f, (float)this.lx + lowOffset, (float)this.uy + highOffset, 0.0f, (float)this.lx + lowOffset, (float)this.ly + lowOffset, 0.0f};
        float[] tex = new float[]{texX, texLY, texX, texY, texLX, texY, texLX, texLY};
        QuadArray planeGeom = new QuadArray(4);
        planeGeom.setCoordinates(0, verts);
        planeGeom.setTextureCoordinates(0, 0, 2, tex);
        this.ap = new Appearance();
        this.ap.setPolygonAttributes(this.overlay.getPolygonAttributes());
        this.ap.setRenderingAttributes(this.overlay.getRenderingAttributes());
        this.ap.setTextureAttributes(this.overlay.getTextureAttributes());
        this.ap.setTransparencyAttributes(this.overlay.getTransparencyAttributes());
        Material m = new Material();
        m.setLightingEnabled(false);
        this.ap.setMaterial(m);
        this.shape = new Shape3D(planeGeom, this.ap);
        this.shape.setName("Window");
    }

    public Shape3D getShape() {
        return this.shape;
    }

    public void swap() {
    }

    protected UISubOverlayBase(UIOverlay overlay, int lx, int ly, int ux, int uy) {
        this.overlay = overlay;
        this.lx = lx;
        this.ly = ly;
        this.ux = ux;
        this.uy = uy;
        this.width = ux - lx + 1;
        this.height = uy - ly + 1;
        this.bounds = new Rectangle(lx, overlay.height - uy, this.width, this.height);
        this.texWidth = UISubOverlayBase.smallestPower(this.width);
        this.texHeight = UISubOverlayBase.smallestPower(this.height);
        this.buildShape();
    }
}

