/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.ui.swingui;

import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JTextField;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import org.xith3d.scenegraph.Node;
import org.xith3d.ui.swingui.UIDirtyRegion;
import org.xith3d.ui.swingui.UIDragDropInterface;
import org.xith3d.ui.swingui.UIDraggingInformation;
import org.xith3d.ui.swingui.UIOverlay;
import org.xith3d.ui.swingui.UIOverlayInterface;
import org.xith3d.ui.swingui.UIRepaintManager;
import org.xith3d.ui.swingui.UIWindowManager;
import org.xith3d.utility.logging.X3DLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIWindow
implements UIOverlayInterface,
UIDragDropInterface {
    private BufferedImage buffer;
    private int width;
    private int height;
    private boolean clipAlpha;
    private boolean blendAlpha;
    private Frame window;
    private Component focusedComponent = null;
    private JComponent root;
    private static UIRepaintManager repaintMgr = new UIRepaintManager();
    private UIOverlay overlay;
    private boolean packed = false;
    private UIWindowManager manager = null;
    private boolean disabled = false;
    private boolean draggable = false;
    boolean textComponentFocus = false;
    Component last = null;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWindowManager(UIWindowManager manager) {
        this.manager = manager;
    }

    public UIWindowManager getWindowManager() {
        return this.manager;
    }

    public void setRoot(JComponent root) {
        this.window.add(root);
        this.root = root;
        this.pack();
        this.pack();
        repaintMgr.markCompletelyDirty(root);
    }

    private void constructBuffer() {
        this.buffer = this.clipAlpha || this.blendAlpha ? new BufferedImage(this.width + 50, this.height + 50, 2) : new BufferedImage(this.width + 50, this.height + 50, 1);
    }

    public BufferedImage getBuffer() {
        return this.buffer;
    }

    public UIOverlay getOverlay() {
        return this.overlay;
    }

    private Component dispatchMouseEvent(int index, Component c, MouseEvent me) {
        Point mousePoint = me.getPoint();
        Component retValue = null;
        if (c instanceof Container) {
            Container ca = (Container)c;
            Component[] cs = ca.getComponents();
            for (int i = 0; i < cs.length; ++i) {
                if (!cs[i].getBounds().contains(mousePoint) || !cs[i].isVisible()) continue;
                Point compPoint = new Point(cs[i].getLocation());
                Point newPoint = new Point(mousePoint.x - compPoint.x, mousePoint.y - compPoint.y);
                MouseEvent newEvent = new MouseEvent(cs[i], me.getID(), me.getWhen(), me.getModifiers(), newPoint.x, newPoint.y, me.getClickCount(), false, me.getButton());
                Component focus = this.dispatchMouseEvent(index + 1, cs[i], newEvent);
                if (retValue == null && focus != null) {
                    retValue = focus;
                }
                if (!me.isConsumed()) continue;
                System.out.println("consumed");
                return cs[i];
            }
        }
        if (!c.isVisible()) {
            return null;
        }
        if (!c.isEnabled()) {
            return null;
        }
        c.dispatchEvent(me);
        if (retValue != null) {
            return retValue;
        }
        if (c.isFocusable()) {
            return c;
        }
        return null;
    }

    private UIDraggingInformation startDrag(int index, Component c, MouseEvent me) {
        Point mousePoint = me.getPoint();
        UIDraggingInformation retValue = null;
        X3DLog.debug("c is of type : ", c.getClass().getSimpleName());
        if (c instanceof Container) {
            Container ca = (Container)c;
            Component[] cs = ca.getComponents();
            for (int i = 0; i < cs.length; ++i) {
                if (!cs[i].getBounds().contains(mousePoint) || !cs[i].isVisible()) continue;
                Point compPoint = new Point(cs[i].getLocation());
                me.translatePoint(-compPoint.x, -compPoint.y);
                UIDraggingInformation focus = this.startDrag(index + 1, cs[i], me);
                me.translatePoint(compPoint.x, compPoint.y);
                if (retValue != null || focus == null) continue;
                retValue = focus;
            }
        }
        if (!c.isVisible()) {
            X3DLog.debug("return null");
            return null;
        }
        if (retValue != null) {
            X3DLog.debug("return retValue");
            return retValue;
        }
        if (c instanceof UIDragDropInterface) {
            return ((UIDragDropInterface)((Object)c)).startDrag(me);
        }
        X3DLog.debug("return null cause no focus");
        return null;
    }

    public boolean dragging(int index, Component c, MouseEvent me, UIDraggingInformation info) {
        Point mousePoint = me.getPoint();
        boolean retValue = false;
        if (c instanceof Container) {
            Container ca = (Container)c;
            Component[] cs = ca.getComponents();
            for (int i = 0; i < cs.length; ++i) {
                if (!cs[i].getBounds().contains(mousePoint) || !cs[i].isVisible()) continue;
                Point compPoint = new Point(cs[i].getLocation());
                me.translatePoint(-compPoint.x, -compPoint.y);
                boolean focus = this.dragging(index + 1, cs[i], me, info);
                me.translatePoint(compPoint.x, compPoint.y);
                if (retValue || !focus) continue;
                retValue = focus;
            }
        }
        if (!c.isVisible()) {
            return false;
        }
        if (retValue) {
            return retValue;
        }
        if (c instanceof UIDragDropInterface) {
            return ((UIDragDropInterface)((Object)c)).dragging(me, info);
        }
        return false;
    }

    public boolean drop(int index, Component c, MouseEvent me, UIDraggingInformation info) {
        Point mousePoint = me.getPoint();
        boolean retValue = false;
        if (c instanceof Container) {
            Container ca = (Container)c;
            Component[] cs = ca.getComponents();
            for (int i = 0; i < cs.length; ++i) {
                if (!cs[i].getBounds().contains(mousePoint) || !cs[i].isVisible()) continue;
                Point compPoint = new Point(cs[i].getLocation());
                me.translatePoint(-compPoint.x, -compPoint.y);
                boolean focus = this.drop(index + 1, cs[i], me, info);
                me.translatePoint(compPoint.x, compPoint.y);
                if (retValue || !focus) continue;
                retValue = focus;
            }
        }
        if (!c.isVisible()) {
            return false;
        }
        if (retValue) {
            return retValue;
        }
        if (c instanceof UIDragDropInterface) {
            return ((UIDragDropInterface)((Object)c)).dropped(me, info);
        }
        return false;
    }

    private void getDirtyAreas(Point curPoint, JComponent c, ArrayList<UIDirtyRegion> areas) {
        UIDirtyRegion dr;
        if (!c.isVisible()) {
            return;
        }
        Point p = new Point(c.getLocation());
        p.x += curPoint.x;
        p.y += curPoint.y;
        if (c instanceof Container) {
            JComponent ca = c;
            Component[] cs = ca.getComponents();
            for (int i = 0; i < cs.length; ++i) {
                if (!(cs[i] instanceof JComponent)) continue;
                this.getDirtyAreas(p, (JComponent)cs[i], areas);
            }
        }
        if ((dr = repaintMgr.getUIDirtyRegion(c)) != null) {
            Rectangle absR = new Rectangle(dr.getCompDirty());
            Point newPoint = new Point(absR.x + p.x, absR.y + p.y);
            absR.setLocation(newPoint);
            dr.setAbsDirty(absR);
            areas.add(dr);
            repaintMgr.removeUIDirtyRegion(c);
        }
    }

    public ArrayList<?> getDirtyAreas() {
        ArrayList<UIDirtyRegion> list = new ArrayList<UIDirtyRegion>();
        this.getDirtyAreas(new Point(), (JComponent)this.getRootComponent(), list);
        return list;
    }

    public void pack() {
        if (this.root instanceof JInternalFrame) {
            ((JInternalFrame)this.root).pack();
        }
        this.pack(this.getRootComponent());
    }

    private void pack(Component c) {
        if (c instanceof Container) {
            Container ca = (Container)c;
            Component[] cs = ca.getComponents();
            for (int i = 0; i < cs.length; ++i) {
                this.pack(cs[i]);
            }
        }
        if (c.getParent() != null) {
            c.addNotify();
        }
        if (c instanceof JComponent) {
            ((JComponent)c).doLayout();
            ((JComponent)c).revalidate();
        }
        c.setVisible(true);
        if (c instanceof JTextField) {
            Caret caret = ((JTextField)c).getCaret();
            caret.setBlinkRate(0);
        }
    }

    private Component getRootComponent() {
        return this.root;
    }

    public void setComponentFocus(Component focus) {
        boolean same;
        boolean bl = same = focus == this.focusedComponent;
        if (this.focusedComponent != null) {
            if (this.focusedComponent instanceof JTextField) {
                this.textComponentFocus = false;
                Caret caret = ((JTextField)this.focusedComponent).getCaret();
                if (caret.isVisible()) {
                    caret.setBlinkRate(0);
                    caret.setVisible(false);
                }
            }
            if (same || this.focusedComponent instanceof FocusListener) {
                // empty if block
            }
        }
        if (focus != null && focus.isEnabled()) {
            this.focusedComponent = focus;
            this.getWindowManager().setOverlayFocus(this);
            if (this.focusedComponent instanceof JTextField) {
                this.textComponentFocus = true;
            }
            if (!same && this.focusedComponent instanceof FocusListener) {
                // empty if block
            }
        } else if (focus == null) {
            this.focusedComponent = null;
        }
    }

    public void setVisible(boolean visible) {
        this.getWindowManager().setVisible(this, visible);
    }

    public void dispatchEvent(AWTEvent e) {
        if (e instanceof MouseEvent) {
            Component focus = this.dispatchMouseEvent(0, this.getRootComponent(), (MouseEvent)e);
            if (focus != null) {
                focus.dispatchEvent(new MouseEvent(focus, 504, 0L, 16, focus.getLocation().x, focus.getLocation().y, 0, false));
            }
            if (focus != null && this.last == null) {
                this.last = focus;
            } else if (this.last != null && this.last != focus) {
                this.last.dispatchEvent(new MouseEvent(this.last, 505, 0L, 16, this.last.getLocation().x, this.last.getLocation().y, 0, false));
                this.last = focus;
            }
            if (focus != this.focusedComponent && focus != null && ((MouseEvent)e).getID() == 501) {
                this.setComponentFocus(focus);
            }
        } else if (e instanceof KeyEvent && this.focusedComponent != null) {
            this.focusedComponent.dispatchEvent(e);
        }
    }

    public synchronized void renderToBuffer(ArrayList<?> dirtyList) {
        if (!this.packed) {
            this.pack();
            this.packed = true;
        }
        final Graphics g = this.buffer.getGraphics();
        if (this.blendAlpha) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(AlphaComposite.Src);
            g.setColor(new Color(0, 0, 0, 0));
            g.fillRect(0, 0, this.width, this.height);
            g2.setComposite(AlphaComposite.SrcOver);
        }
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    UIWindow.this.root.print(g);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        g.dispose();
        this.overlay.repaintChanged(this.buffer, dirtyList);
    }

    @Override
    public void getSize(Dimension dim) {
        dim.setSize(this.width, this.height);
    }

    @Override
    public void update() {
        if (!repaintMgr.isDirty()) {
            return;
        }
        ArrayList<UIDirtyRegion> dirtyList = new ArrayList<UIDirtyRegion>();
        this.getDirtyAreas(new Point(), (JComponent)this.getRootComponent(), dirtyList);
        if (dirtyList.size() > 0) {
            this.renderToBuffer(dirtyList);
            this.overlay.update();
        }
    }

    @Override
    public Node getRoot() {
        return this.overlay.getRoot();
    }

    @Override
    public boolean isOpaque() {
        return this.overlay.isOpaque();
    }

    @Override
    public UIDraggingInformation startDrag(MouseEvent me) {
        return this.startDrag(0, this.getRootComponent(), me);
    }

    @Override
    public boolean dragging(MouseEvent me, UIDraggingInformation info) {
        return this.dragging(0, this.getRootComponent(), me, info);
    }

    @Override
    public boolean dropped(MouseEvent me, UIDraggingInformation info) {
        RepaintManager.setCurrentManager(repaintMgr);
        boolean val = this.drop(0, this.getRootComponent(), me, info);
        return val;
    }

    public void setDisabled(boolean b) {
        this.disabled = b;
        this.overlay.getRoot().setPickable(!b);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDraggable(boolean b) {
        this.draggable = b;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public int getX() {
        return this.getWindowManager().getX(this);
    }

    public int getY() {
        return this.getWindowManager().getY(this);
    }

    public void setPosition(int x, int y) {
        this.getWindowManager().setPosition(this, x, y);
    }

    public void setFocus(boolean hasFocus) {
        X3DLog.debug("setting window focus to ", hasFocus);
        if (!hasFocus && this.focusedComponent != null) {
            this.setComponentFocus(null);
        }
    }

    public UIWindow(int width, int height, boolean clipAlpha, boolean blendAlpha) {
        this.width = width;
        this.height = height;
        this.clipAlpha = clipAlpha;
        this.blendAlpha = blendAlpha;
        this.constructBuffer();
        this.window = new Frame(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
        this.window.setEnabled(true);
        this.window.setSize(width, height);
        this.window.setUndecorated(true);
        this.window.addNotify();
        RepaintManager.setCurrentManager(repaintMgr);
        this.overlay = new UIOverlay(width, height, clipAlpha, blendAlpha, false);
    }

    public UIWindow(JComponent root, int width, int height, boolean clipAlpha, boolean blendAlpha) {
        this(width, height, clipAlpha, blendAlpha);
        this.setRoot(root);
    }
}

