/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.awt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Toolkit;

public final class WindowHelper {
    public static Point getCenterCoordinates(Dimension d) {
        Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
        Point ul = new Point();
        ul.x = (s.width - d.width) / 2;
        ul.y = (s.height - d.height) / 2;
        return ul;
    }

    public static void center(Component f) {
        f.setLocation(WindowHelper.getCenterCoordinates(f.getSize()));
    }

    public static void center(Frame f, GraphicsConfiguration screen) {
        Point p = WindowHelper.getCenterCoordinates(f.getSize());
        p.translate(screen.getBounds().x, screen.getBounds().y);
        f.setLocation(p);
    }

    private WindowHelper() {
    }
}

