/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.cache;

import java.util.ArrayList;
import java.util.HashMap;
import org.jagatoo.datatypes.NamedObject;
import org.xith3d.utility.cache.Cachable;
import org.xith3d.utility.cache.CacheMatchInterface;
import org.xith3d.utility.cache.CacheNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache<T>
implements NamedObject {
    public static final int FIND_ANY = 0;
    public static final int FIND_BEST = 1;
    public static final int FIND_EXACT = 2;
    public static final int FIND_FIRST = 3;
    private static HashMap<String, Cache<?>> caches = new HashMap();
    private final String name;
    private final boolean shareable;
    private final ArrayList<CacheNode<T>> items;
    private int attempts = 0;
    private int hits = 0;

    public Cache(String name, boolean shareable) {
        this.name = name;
        this.shareable = shareable;
        this.items = new ArrayList();
        caches.put(name, this);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public static Cache<?> getCache(Class<?> classType, boolean shareable) {
        String key = classType.getName() + shareable;
        Cache<Object> c = caches.get(key);
        if (c == null) {
            c = new Cache(key, shareable);
        }
        return c;
    }

    private CacheNode<T> findObject(T o) {
        for (CacheNode<T> cn : this.items) {
            if (cn.o != o) continue;
            return cn;
        }
        return null;
    }

    public synchronized void put(T o) {
        CacheNode<T> n = this.findObject(o);
        if (n != null) {
            if (this.shareable) {
                int num = n.getNumUsers();
                if (num >= 0) {
                    n.setNumUsers(num - 1);
                }
                n.setTimeLastAccessed(System.currentTimeMillis());
            }
        } else {
            n = new CacheNode<T>(o);
            n.setNumUsers(0);
            n.setTimeCreated(System.currentTimeMillis());
            this.items.add(n);
        }
    }

    private CacheNode<T> find(CacheMatchInterface<T> matcher, int findStyle) {
        CacheNode<T> best = null;
        float bestVal = 0.0f;
        for (CacheNode<T> cn : this.items) {
            if (matcher != null) {
                float m = matcher.match(cn.o);
                if (m == 1.0f) {
                    return cn;
                }
                if (!(m > 0.0f)) continue;
                if (findStyle == 3) {
                    return cn;
                }
                if (!(m > bestVal)) continue;
                bestVal = m;
                best = cn;
                continue;
            }
            return cn;
        }
        if (findStyle == 2) {
            return null;
        }
        return best;
    }

    private T get(CacheMatchInterface<T> matcher, int findStyle) {
        ++this.attempts;
        CacheNode<T> n = this.find(matcher, findStyle);
        if (n == null) {
            return null;
        }
        if (this.shareable) {
            n.setNumRequested(n.getNumRequested() + 1);
            n.setNumUsers(n.getNumUsers() + 1);
            n.setTimeLastAccessed(System.currentTimeMillis());
        } else {
            this.items.remove(n);
        }
        ++this.hits;
        return n.o;
    }

    public synchronized T getBest(CacheMatchInterface<T> matcher) {
        return this.get(matcher, 1);
    }

    public synchronized T getFirst(CacheMatchInterface<T> matcher) {
        return this.get(matcher, 3);
    }

    public synchronized T getAny() {
        return this.get(null, 0);
    }

    public synchronized void dumpCacheInfo(boolean printItems) {
        System.out.println("Cache : " + this.name);
        long totalMemory = 0L;
        for (CacheNode<T> cn : this.items) {
            if (!(cn.o instanceof Cachable)) continue;
            totalMemory += ((Cachable)cn.o).memoryUsed();
            if (!printItems) continue;
            System.out.println("   " + ((Cachable)cn.o).getName() + " " + ((Cachable)cn.o).memoryUsed() + " bytes");
        }
        System.out.println("   " + this.items.size() + " items using " + totalMemory + " bytes");
        System.out.println("   " + this.attempts + " attempts with " + this.hits + " hits (" + (float)this.hits / (float)this.attempts + "%)");
    }

    public static void dumpAllCacheInfo() {
        for (Cache<?> c : caches.values()) {
            c.dumpCacheInfo(true);
        }
    }
}

