/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.camera.flight;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.InflaterInputStream;
import org.openmali.vecmath2.Matrix3f;
import org.openmali.vecmath2.Point3f;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.scenegraph.Transformable;
import org.xith3d.utility.camera.flight.CameraFlightListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CameraFlight {
    private List<InterpolationPoint> interPoints;
    private long startTime;
    private Matrix3f camRot;
    private float t0i;
    private float t0t;
    private float d;
    private int i1;
    private int frames;
    private InterpolationPoint ip1;
    private InterpolationPoint ip2;
    private List<CameraFlightListener> listeners = new ArrayList<CameraFlightListener>(1);

    public void addCameraFlightListener(CameraFlightListener l) {
        this.listeners.add(l);
    }

    public void removeCameraFlightListener(CameraFlightListener l) {
        this.listeners.remove(l);
    }

    public void updateCamera(Transformable cam, long gameTime, UpdatingThread.TimingMode timingMode) {
        this.t0t = timingMode.getMicroSeconds(gameTime - this.startTime);
        this.ip1 = this.interPoints.get(this.i1);
        while (this.t0t > this.t0i + this.ip1.deltaTime) {
            this.t0i += this.ip1.deltaTime;
            if (this.i1 + 2 >= this.interPoints.size()) {
                this.restart(gameTime, timingMode);
            }
            this.ip1 = this.interPoints.get(++this.i1);
        }
        this.ip2 = this.interPoints.get(this.i1 + 1);
        this.d = this.ip1.deltaTime > 0.0f ? (this.t0t - this.t0i) / this.ip1.deltaTime : 0.0f;
        this.camRot.interpolate(this.ip1.rot, this.ip2.rot, this.d);
        cam.getTransform().set(this.camRot);
        cam.getTransform().setTranslation(this.ip1.pos.getX() + (this.ip2.pos.getX() - this.ip1.pos.getX()) * this.d, this.ip1.pos.getY() + (this.ip2.pos.getY() - this.ip1.pos.getY()) * this.d, this.ip1.pos.getZ() + (this.ip2.pos.getZ() - this.ip1.pos.getZ()) * this.d);
        ++this.frames;
    }

    public void restart(long gameTime, UpdatingThread.TimingMode timingMode) {
        float averageFPS = (float)this.frames / this.t0t * 1000000.0f;
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onCameraFlightEnded(this.frames, (long)this.t0t, averageFPS);
        }
        this.startTime = gameTime;
        this.t0i = 0.0f;
        this.t0t = 0.0f;
        this.i1 = -1;
        this.frames = 0;
    }

    public void start(long startTime) {
        this.camRot = new Matrix3f();
        this.startTime = startTime;
        this.t0i = 0.0f;
        this.i1 = 0;
        this.frames = 0;
    }

    public void addRotPos(Matrix3f rot, Point3f pos, float deltaTime) {
        InterpolationPoint interPoint = new InterpolationPoint();
        interPoint.rot = new Matrix3f(rot);
        interPoint.pos = new Point3f(pos);
        interPoint.deltaTime = deltaTime * 1000.0f;
        this.interPoints.add(interPoint);
    }

    private String readLine(InputStream in) throws IOException {
        char c;
        StringBuffer str = new StringBuffer();
        int EOL = 10;
        while (in.available() > 0 && (c = (char)in.read()) != '\n') {
            str.append(c);
        }
        return str.toString();
    }

    public void load(InputStream in) throws IOException {
        String line;
        this.interPoints = new ArrayList<InterpolationPoint>();
        Matrix3f rot = new Matrix3f();
        Point3f pos = new Point3f();
        Format format = Format.get(Byte.valueOf(this.readLine(in)));
        this.readLine(in);
        if (format == Format.COMPRESSED) {
            if (in instanceof BufferedInputStream) {
                throw new IllegalArgumentException("The InputStream must not be a BufferedInputStream, if read from a COMPRESSED file.");
            }
            in = new InflaterInputStream(in);
        }
        if (!(in instanceof BufferedInputStream)) {
            in = new BufferedInputStream(in);
        }
        while ((line = this.readLine(in)) != null && line.length() != 0 && Character.getType(line.charAt(0)) != 0) {
            String[] comps = line.split(" ");
            rot.m00(Float.parseFloat(comps[0]));
            rot.m01(Float.parseFloat(comps[1]));
            rot.m02(Float.parseFloat(comps[2]));
            line = this.readLine(in);
            comps = line.split(" ");
            rot.m10(Float.parseFloat(comps[0]));
            rot.m11(Float.parseFloat(comps[1]));
            rot.m12(Float.parseFloat(comps[2]));
            line = this.readLine(in);
            comps = line.split(" ");
            rot.m20(Float.parseFloat(comps[0]));
            rot.m21(Float.parseFloat(comps[1]));
            rot.m22(Float.parseFloat(comps[2]));
            line = this.readLine(in);
            comps = line.split(" ");
            pos.setX(Float.parseFloat(comps[0]));
            pos.setY(Float.parseFloat(comps[1]));
            pos.setZ(Float.parseFloat(comps[2]));
            line = this.readLine(in);
            float t = Long.parseLong(line);
            line = this.readLine(in);
            this.addRotPos(rot, pos, t);
        }
    }

    public void load(URL url) throws IOException {
        this.load(url.openStream());
    }

    public void load(File file) throws IOException {
        this.load(new FileInputStream(file));
    }

    public void load(String filename) throws IOException {
        this.load(new File(filename));
    }

    public CameraFlight() {
    }

    public CameraFlight(List<InterpolationPoint> interPoints) {
        this.interPoints = interPoints;
    }

    public CameraFlight(InputStream in) throws IOException {
        this();
        this.load(in);
    }

    public CameraFlight(URL url) throws IOException {
        this();
        this.load(url);
    }

    public CameraFlight(File file) throws IOException {
        this();
        this.load(file);
    }

    public CameraFlight(String filename) throws IOException {
        this();
        this.load(filename);
    }

    public class InterpolationPoint {
        public Matrix3f rot;
        public Point3f pos;
        public float deltaTime;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        UNCOMPRESSED(0),
        COMPRESSED(1);

        private byte b;

        public byte getByte() {
            return this.b;
        }

        private Format(byte b) {
            this.b = b;
        }

        public static Format get(byte b) {
            switch (b) {
                case 0: {
                    return UNCOMPRESSED;
                }
                case 1: {
                    return COMPRESSED;
                }
            }
            throw new IllegalArgumentException("Unknown type " + b);
        }
    }
}

