/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.characters;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.BitSet;
import org.xith3d.utility.characters.CharIndex;

class BitSetOptimizedCharIndex
extends CharIndex {
    private Charset charset;
    private BitSet bitSetCache;
    private int numPrintables = -1;

    public final CharIndex.MemoryStrategy getMemoryStrategy() {
        return CharIndex.MemoryStrategy.BITSET_OPTIMIZED;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getTotalNumberOfCharacters() {
        return 32768;
    }

    public int getNumberOfPrintableChars() {
        return this.numPrintables;
    }

    public int getIndex(char ch) {
        int result = -1;
        if (this.bitSetCache.get(ch)) {
            result = this.bitSetCache.get(0, ch).cardinality();
        }
        return result;
    }

    private BitSet createBitSetCache(Charset charset) {
        char c = this.getTotalNumberOfCharacters();
        BitSet result = new BitSet(c);
        CharBuffer charBuffer = CharBuffer.allocate(1);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        CharsetEncoder encoder = charset.newEncoder();
        this.numPrintables = 0;
        for (char ch = '\u0000'; ch < c; ch = (char)(ch + '\u0001')) {
            if (BitSetOptimizedCharIndex.isPrintable(ch, encoder, charBuffer, byteBuffer)) {
                result.set(ch);
                ++this.numPrintables;
            }
            charBuffer.clear();
            byteBuffer.clear();
        }
        return result;
    }

    public BitSetOptimizedCharIndex(Charset charset) {
        this.charset = charset;
        this.bitSetCache = this.createBitSetCache(charset);
    }
}

