/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.characters;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import org.xith3d.utility.characters.CharIndex;

class SpaceOptimizedCharIndex
extends CharIndex {
    private Charset charset;
    private CharsetEncoder encoder;
    private CharBuffer charBuffer;
    private ByteBuffer byteBuffer;
    private int numPrintables = -1;

    public final CharIndex.MemoryStrategy getMemoryStrategy() {
        return CharIndex.MemoryStrategy.SPACE_OPTIMIZED;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int getTotalNumberOfCharacters() {
        return 32768;
    }

    public int getNumberOfPrintableChars() {
        if (this.numPrintables >= 0) {
            return this.numPrintables;
        }
        this.numPrintables = 0;
        char c = this.getTotalNumberOfCharacters();
        for (char i = '\u0000'; i <= c; i = (char)(i + '\u0001')) {
            if (SpaceOptimizedCharIndex.isPrintable(i, this.encoder, this.charBuffer, this.byteBuffer)) {
                ++this.numPrintables;
            }
            this.charBuffer.clear();
            this.byteBuffer.clear();
        }
        return this.numPrintables;
    }

    public int getIndex(char ch) {
        int result = -1;
        for (char i = '\u0000'; i <= ch; i = (char)(i + '\u0001')) {
            if (SpaceOptimizedCharIndex.isPrintable(i, this.encoder, this.charBuffer, this.byteBuffer)) {
                ++result;
            }
            this.charBuffer.clear();
            this.byteBuffer.clear();
        }
        return result;
    }

    public SpaceOptimizedCharIndex(Charset charset) {
        this.charset = charset;
        this.encoder = charset.newEncoder();
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        this.encoder.onMalformedInput(CodingErrorAction.REPORT);
        this.charBuffer = CharBuffer.allocate(1);
        this.byteBuffer = ByteBuffer.allocate(2);
    }
}

