/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.commandline.arguments;

import org.jagatoo.commandline.Argument;
import org.jagatoo.commandline.CommandlineParsingException;

public class DisplayModeArgument
extends Argument {
    public static final DisplayModeArgument INSTANCE = new DisplayModeArgument();

    protected int[] parseValueImpl(String rawValue) throws CommandlineParsingException {
        String[] parts = rawValue.split("x");
        if (parts.length < 2) {
            throw new CommandlineParsingException("Invalid value for " + this + ": " + rawValue);
        }
        int[] result = new int[Math.min(parts.length, 4)];
        result[0] = Integer.parseInt(parts[0]);
        result[1] = Integer.parseInt(parts[1]);
        if (result[0] > 4096 || result[1] > 4096) {
            throw new CommandlineParsingException("Invalid value for " + this + ": " + rawValue);
        }
        if (parts.length >= 3) {
            result[2] = Integer.parseInt(parts[2]);
            if (result[2] != 8 && result[2] != 16 && result[2] != 24 && result[2] != 32) {
                throw new CommandlineParsingException("Invalid value for " + this + ": " + rawValue);
            }
        }
        if (parts.length >= 4) {
            result[3] = Integer.parseInt(parts[3]);
        }
        return result;
    }

    private DisplayModeArgument() {
        super('m', "display-mode", "Selects the display mode (resolution and color depth) in the following form:\n\nExample: 1024x768x32x60\n\nThe first two fields must be provided. The color depth can be omitted as well as the frequency.", true);
    }
}

