/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.general;

import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseVector<T> {
    private LinkedNode first = null;
    private LinkedNode last = null;

    private LinkedNode findPred(int i) {
        LinkedNode p1 = null;
        LinkedNode p2 = this.first;
        while (p2 != null) {
            if (p2.i >= i) {
                return p1;
            }
            p1 = p2;
            p2 = p2.next;
        }
        return p1;
    }

    public void insertAt(int i, T obj) {
        LinkedNode node2 = new LinkedNode(i, obj);
        if (this.first == null) {
            node2.prev = null;
            node2.next = null;
            node2.obj = obj;
            this.first = node2;
            this.last = node2;
        } else {
            LinkedNode pred = this.findPred(i);
            if (pred == null) {
                node2.next = this.first;
                node2.prev = null;
                this.first.prev = node2;
                this.first = node2;
            } else {
                node2.prev = pred;
                node2.next = pred.next;
                pred.next = node2;
                if (node2.next != null) {
                    node2.next.prev = node2;
                }
            }
        }
    }

    private LinkedNode nodeAt(int i) {
        if (this.first == null) {
            return null;
        }
        LinkedNode pred = this.findPred(i);
        if (pred == null) {
            if (this.first.i == i) {
                return this.first;
            }
            return null;
        }
        if (pred.next == null) {
            return null;
        }
        if (pred.next.i == i) {
            return pred.next;
        }
        return null;
    }

    public T elementAt(int i) {
        LinkedNode node2 = this.nodeAt(i);
        if (node2 == null) {
            return null;
        }
        return node2.obj;
    }

    public void removeAt(int i) {
        LinkedNode node2 = this.nodeAt(i);
        if (node2 != null) {
            if (this.last == node2) {
                this.last = node2.prev;
            }
            if (this.first == node2) {
                this.first = node2.next;
            }
            if (node2.prev != null) {
                node2.prev.next = node2.next;
            }
            if (node2.next != null) {
                node2.next.prev = node2.prev;
            }
        }
    }

    public void sortElements(ArrayList<T> within, ArrayList<T> without, int start, int stop) {
        LinkedNode p = this.first;
        while (p != null) {
            if (p.i < start || p.i > stop) {
                without.add(p.obj);
            } else {
                within.add(p.obj);
            }
            p = p.next;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LinkedNode {
        public LinkedNode next;
        public LinkedNode prev;
        public T obj;
        public int i;

        public LinkedNode(int i, T obj) {
            this.i = i;
            this.obj = obj;
            this.next = null;
            this.prev = null;
        }
    }
}

