/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.geometry;

import java.util.ArrayList;
import java.util.Vector;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TexCoord2f;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.utility.geometry.GeometryInfo;
import org.xith3d.utility.geometry.VertexData;

public class GeometryCreator {
    private ArrayList<Point3f> coordinates = new ArrayList();
    private ArrayList<Vector3f> normals = new ArrayList();
    private ArrayList<Colorf> colors = new ArrayList();
    private ArrayList<TexCoord2f[]> texCoords = new ArrayList();
    private Vector<Integer> coordIndices = new Vector();
    private Vector<Integer> normalIndices = new Vector();
    private Vector<Integer> colorIndices = new Vector();
    private Vector<Integer> texIndices = new Vector();
    private Vector<Integer> faceSizes = new Vector();
    private Vector<Integer> smoothGroups = new Vector();
    private int lastFaceEnd = 0;
    private int texSets = 1;

    public GeometryCreator() {
    }

    public GeometryCreator(int textureCoordinateSets) {
        this.texSets = textureCoordinateSets;
    }

    public void addCoordinate(float x, float y, float z) {
        this.addCoordinate(new Point3f(x, y, z));
    }

    public void addCoordinate(Point3f p) {
        this.coordinates.add(p);
    }

    public void addNormal(float x, float y, float z) {
        this.normals.add(new Vector3f(x, y, z));
    }

    public void addNormal(Vector3f v) {
        this.normals.add(v);
    }

    public void addColor(float r, float g, float b) {
        this.addColor(new Colorf(r, g, b));
    }

    public void addColor(float r, float g, float b, float a) {
        this.addColor(new Colorf(r, g, b, a));
    }

    public void addTexCoord(float s, float t) {
        if (this.texSets > 1) {
            throw new IllegalArgumentException("For more than 1 texture coord set, use addTexCoord(TexCoord2f[])");
        }
        this.addTexCoord(new TexCoord2f(s, t));
    }

    public void addTexCoord(TexCoord2f t) {
        if (this.texSets > 1) {
            throw new IllegalArgumentException("For more than 1 texture coord set, use addTexCoord(TexCoord2f[])");
        }
        this.addTexCoords(new TexCoord2f[]{t});
    }

    public void addTexCoords(TexCoord2f[] t) {
        if (t.length != this.texSets) {
            throw new IllegalArgumentException("Number of texture coordinates (" + t.length + ") differs from number of textureSets defined(" + this.texSets + ")");
        }
        this.texCoords.add(t);
    }

    public void addColor(Colorf c) {
        this.colors.add(c);
    }

    public void addCoordIndex(int i) {
        this.coordIndices.add(i);
    }

    public void addNormalIndex(int i) {
        this.normalIndices.add(i);
    }

    public void addColorIndex(int i) {
        this.colorIndices.add(i);
    }

    public void addTexIndex(int i) {
        this.texIndices.add(i);
    }

    public void setFaceSmoothingGroup(int group) {
        this.smoothGroups.add(group);
    }

    public void nextFace() {
        int count = this.coordIndices.size();
        if (this.lastFaceEnd == count) {
            return;
        }
        if (this.lastFaceEnd + 3 != count) {
            throw new IllegalStateException("Currently only triangles are supported (face with 3 indices)");
        }
        if (this.normalIndices.size() != 0 && this.normalIndices.size() != count) {
            throw new IllegalStateException("Different number of coordinate and normal indices");
        }
        if (this.colorIndices.size() != 0 && this.colorIndices.size() != count) {
            throw new IllegalStateException("Different number of coordinate and color indices");
        }
        if (this.texIndices.size() != 0 && this.texIndices.size() != count) {
            throw new IllegalStateException("Different number of coordinate and texture indices");
        }
        this.faceSizes.add(count - this.lastFaceEnd);
        if (this.smoothGroups.size() != 0 && this.smoothGroups.size() != this.faceSizes.size()) {
            throw new IllegalStateException("Different number of faces and smoothing group info");
        }
        this.lastFaceEnd = count;
    }

    public void fillGeometryInfo(GeometryInfo gi) {
        int[] faceData = new int[this.coordIndices.size()];
        VertexData[] vertices = new VertexData[this.coordIndices.size()];
        for (int i = 0; i < this.coordIndices.size(); ++i) {
            VertexData vd = new VertexData();
            vd.coord = new Point3f(this.coordinates.get(this.coordIndices.get(i)));
            if (this.normalIndices.size() != 0) {
                vd.normal = new Vector3f(this.normals.get(this.normalIndices.get(i)));
            }
            if (this.colorIndices.size() != 0) {
                vd.color = this.colors.get(this.colorIndices.get(i));
            }
            if (this.texIndices.size() != 0) {
                vd.texCoords = this.texCoords.get(this.texIndices.get(i));
            }
            faceData[i] = i;
            vertices[i] = vd;
        }
        int[] smooth = new int[this.faceSizes.size()];
        for (int i = 0; i < smooth.length; ++i) {
            smooth[i] = this.smoothGroups.size() > 0 ? this.smoothGroups.get(i) : -1;
        }
        gi.vertices = vertices;
        gi.triangles = faceData;
        gi.smoothGroups = smooth;
        gi.state = 1;
    }
}

