/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.geometry;

import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.Point3f;
import org.openmali.vecmath2.TupleNf;
import org.openmali.vecmath2.Vector3f;
import org.xith3d.scenegraph.Geometry;
import org.xith3d.scenegraph.LineArray;
import org.xith3d.scenegraph.Shape3D;

public class NormalsVisualizer
extends Shape3D {
    public static final Colorf DEFAULT_NORMAL_COLOR = Colorf.GREEN;
    private Shape3D object;
    private Geometry objectGeom;
    private Point3f[] vertices = null;
    private Vector3f[] normals = null;
    private Point3f[] coords = null;
    private LineArray geometry = null;
    private float normalScale = 1.0f;

    public LineArray getGeometry() {
        return (LineArray)super.getGeometry();
    }

    public void setNormalScale(float scale) {
        this.normalScale = scale;
        if (this.coords != null) {
            this.update();
        }
    }

    public float getNormalScale() {
        return this.normalScale;
    }

    public void update() {
        int i;
        if (this.geometry == null || this.object.getGeometry().getVertexCount() != this.vertices.length) {
            this.vertices = new Point3f[this.object.getGeometry().getVertexCount()];
            this.normals = new Vector3f[this.object.getGeometry().getVertexCount()];
            this.coords = new Point3f[this.vertices.length * 2];
            for (i = 0; i < this.vertices.length; ++i) {
                this.vertices[i] = new Point3f();
                this.normals[i] = new Vector3f();
                this.coords[i * 2 + 0] = new Point3f();
                this.coords[i * 2 + 1] = new Point3f();
            }
            this.geometry = new LineArray(this.coords.length);
        }
        this.objectGeom.getCoordinates(0, this.vertices);
        this.objectGeom.getNormals(0, this.normals);
        for (i = 0; i < this.vertices.length; ++i) {
            this.coords[i * 2 + 0].set((TupleNf)this.vertices[i]);
            this.coords[i * 2 + 1].set((TupleNf)this.vertices[i]);
            this.coords[i * 2 + 1].addX(this.normals[i].getX() * this.getNormalScale());
            this.coords[i * 2 + 1].addY(this.normals[i].getY() * this.getNormalScale());
            this.coords[i * 2 + 1].addZ(this.normals[i].getZ() * this.getNormalScale());
        }
        this.geometry.setCoordinates(0, this.coords);
        this.setGeometry(this.geometry);
    }

    public void setColor(Colorf color) {
        this.getAppearance(true).getColoringAttributes(true).setColor(color);
    }

    public NormalsVisualizer(Shape3D object, Colorf color, float normalScale) {
        this.object = object;
        this.objectGeom = object.getGeometry();
        if ((this.objectGeom.getVertexFormat() & 2) == 0) {
            throw new Error("The given Shape3D's Geometry doesn't have normals.");
        }
        this.update();
        this.getAppearance(true).getLineAttributes(true).setLineAntialiasingEnabled(false);
        this.getAppearance(true).getLineAttributes(true).setLineWidth(1.0f);
        this.setColor(color);
        this.setNormalScale(normalScale);
    }

    public NormalsVisualizer(Shape3D object, Colorf color) {
        this(object, color, 1.0f);
    }

    public NormalsVisualizer(Shape3D object, float normalScale) {
        this(object, DEFAULT_NORMAL_COLOR, normalScale);
    }

    public NormalsVisualizer(Shape3D object) {
        this(object, DEFAULT_NORMAL_COLOR);
    }
}

