/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.image;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class DrawingTools {
    public static void centerText(Component c, Graphics g, String text) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setFont(c.getFont());
        int w = g.getFontMetrics().stringWidth(text);
        int h = g.getFontMetrics().getMaxAscent() + g.getFontMetrics().getMaxDescent();
        int tx = c.getWidth() / 2 - w / 2;
        int ty = c.getHeight() / 2 + h / 3;
        g.setColor(c.getForeground());
        g.drawString(text, tx, ty);
    }

    public static void centerText(Rectangle r, Graphics g, String text) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int w = g.getFontMetrics().stringWidth(text);
        int h = g.getFontMetrics().getMaxAscent() + g.getFontMetrics().getMaxDescent();
        int tx = r.x + r.width / 2 - w / 2;
        int ty = r.y + r.height / 2 + h / 3;
        g.drawString(text, tx, ty);
    }

    public static void drawText(Rectangle r, Graphics g, String text) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int h = g.getFontMetrics().getMaxAscent() + g.getFontMetrics().getMaxDescent();
        int ty = r.y + r.height / 2 + h / 3;
        g.drawString(text, r.x, ty);
    }

    public static void centerShadowedText(Component c, Graphics g, String text) {
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setFont(c.getFont());
        int w = g.getFontMetrics().stringWidth(text);
        int h = g.getFontMetrics().getMaxAscent() + g.getFontMetrics().getMaxDescent();
        int tx = c.getWidth() / 2 - w / 2;
        int ty = c.getHeight() / 2 + h / 4;
        g.setColor(Color.black);
        g.drawString(text, tx + 1, ty + 1);
        g.setColor(c.getForeground());
        g.drawString(text, tx, ty);
    }

    public static void drawImageOnCanvas(Graphics g, BufferedImage back, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        if (sx2 > back.getWidth()) {
            sx2 = back.getWidth();
        }
        if (sy2 > back.getHeight()) {
            sy2 = back.getHeight();
        }
        if (sx1 >= sx2) {
            return;
        }
        if (sy1 >= sy2) {
            return;
        }
        if (sx1 < 0) {
            return;
        }
        if (sy1 < 0) {
            return;
        }
        if (dx2 - dx1 != sx2 - sx1) {
            dx2 = dx1 + (sx2 - sx1);
        }
        if (dy2 - dy1 != sy2 - sy1) {
            dy2 = dy1 + (sy2 - sy1);
        }
        g.drawImage(back, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    public static void tileSegmentsHorizontally(Graphics g, BufferedImage image, int leftWidth, int rightWidth, int dy, int sy, int width, int height) {
        int amount;
        int middleWidth = image.getWidth() - leftWidth - rightWidth;
        int middleTarget = width - leftWidth - rightWidth;
        int imageWidth = image.getWidth();
        DrawingTools.drawImageOnCanvas(g, image, 0, dy, leftWidth, dy + height, 0, sy, leftWidth, sy + height);
        DrawingTools.drawImageOnCanvas(g, image, width - rightWidth, dy, width, dy + height, imageWidth - rightWidth, sy, imageWidth, sy + height);
        int x = leftWidth;
        int check = 0;
        for (int amountLeft = middleTarget; amountLeft > 0; amountLeft -= amount) {
            amount = middleWidth;
            if (amount > amountLeft) {
                amount = amountLeft;
            }
            DrawingTools.drawImageOnCanvas(g, image, x, dy, amount, dy + height, leftWidth, sy, leftWidth + amount, sy + height);
            x += amount;
            if (check++ <= 10) continue;
            break;
        }
    }

    public static void drawSegmentedImage(Graphics g, BufferedImage image, int height, int width, int topWidth, int bottomWidth, int leftWidth, int rightWidth) {
        int middleTarget;
        int amount;
        int borderHeight = image.getHeight();
        DrawingTools.tileSegmentsHorizontally(g, image, leftWidth, rightWidth, 0, 0, width, topWidth);
        DrawingTools.tileSegmentsHorizontally(g, image, leftWidth, rightWidth, height - bottomWidth, borderHeight - bottomWidth, width, bottomWidth);
        int middleHeight = borderHeight - topWidth - bottomWidth;
        int y = topWidth;
        int check = 0;
        for (int amountLeft = middleTarget = height - topWidth - bottomWidth; amountLeft > 0; amountLeft -= amount) {
            amount = middleHeight;
            if (amount > amountLeft) {
                amount = amountLeft;
            }
            DrawingTools.tileSegmentsHorizontally(g, image, leftWidth, rightWidth, y, topWidth, width, amount);
            y += amount;
            if (check++ <= 10) continue;
            break;
        }
    }

    public static void drawImageOnCanvas(Graphics g, int x, int y, Rectangle r, BufferedImage back) {
        int amountY;
        int ux = r.x + (int)r.getWidth();
        int uy = r.y + (int)r.getHeight();
        int amountX = back.getWidth();
        if (amountX + x >= ux) {
            amountX = ux - x;
        }
        if ((amountY = back.getHeight()) + y >= uy) {
            amountY = uy - y;
        }
        g.drawImage(back, x, y, x + amountX, y + amountY, 0, 0, amountX, amountY, null);
    }

    public static void fillWithBackground(Graphics g, Rectangle r, BufferedImage back) {
        if (r.x >= back.getWidth() || r.y >= back.getHeight() || r.x < 0 || r.y < 0) {
            throw new Error("Illegal attempt to place an image at " + r.x + "," + r.y + " when image is " + back.getWidth() + "x" + back.getHeight());
        }
        try {
            DrawingTools.drawImageOnCanvas(g, r.x, r.y, r, back);
        }
        catch (Exception e) {
            throw new Error("Exception attempting to place an image at " + r.x + "," + r.y + " (" + r.width + "x" + r.height + ") " + " when image is " + back.getWidth() + "x" + back.getHeight());
        }
        int x = 0;
        for (int y = r.y; y < r.y + r.height; y += back.getHeight()) {
            for (x = y == r.y ? r.x + back.getWidth() : r.x; x < r.x + r.width; x += back.getWidth()) {
                DrawingTools.drawImageOnCanvas(g, x, y, r, back);
            }
        }
    }

    public static void drawBorderedBox(Graphics g, Rectangle r, BufferedImage back, BufferedImage front) {
        DrawingTools.fillWithBackground(g, r, back);
        g.setClip(4, 4, r.width - 8, r.height - 8);
        DrawingTools.fillWithBackground(g, r, front);
        g.setClip(0, 0, r.width, r.height);
        Color shadow = new Color(0.0f, 0.0f, 0.0f, 0.8f);
        g.setColor(shadow);
        g.drawRect(0, 0, r.width - 1, r.height - 1);
    }

    public static void drawShadowedBox(Graphics g, Rectangle r, Color highlight, Color shadow, Color internal) {
        g.setColor(shadow);
        int tx = r.x + r.width;
        int ty = r.y + r.height;
        g.drawLine(r.x + 1, r.y + 1, tx - 3, r.y + 1);
        g.drawLine(r.x, ty - 1, tx - 1, ty - 1);
        g.drawLine(r.x + 1, r.y + 2, r.x + 1, ty - 3);
        g.drawLine(tx - 1, r.y, tx - 1, ty - 1);
        g.setColor(highlight);
        g.drawRect(r.x, r.y, r.width - 2, r.height - 2);
        g.setColor(internal);
        g.fillRect(r.x + 2, r.y + 2, r.width - 4, r.height - 4);
    }

    public static void drawBox(Graphics g, Rectangle r, Color highlight, Color shadow) {
        g.setColor(shadow);
        int tx = r.x + r.width;
        int ty = r.y + r.height;
        g.drawLine(r.x + 1, r.y + 1, tx - 3, r.y + 1);
        g.drawLine(r.x, ty - 1, tx - 1, ty - 1);
        g.drawLine(r.x + 1, r.y + 2, r.x + 1, ty - 3);
        g.drawLine(tx - 1, r.y, tx - 1, ty - 1);
        g.setColor(highlight);
        g.drawRect(r.x, r.y, r.width - 2, r.height - 2);
    }

    public static void drawShadowedBox(Graphics g, Rectangle r, float alpha) {
        Color shadow = new Color(0.0f, 0.0f, 0.0f, 0.8f);
        Color highlight = new Color(0.0f, 0.0f, 0.0f, 0.1f);
        Color inside = new Color(0.0f, 0.0f, 0.0f, alpha);
        DrawingTools.drawShadowedBox(g, r, highlight, shadow, inside);
    }

    public static void drawShadowedBox(Graphics g, Rectangle r, float highlightAlpha, float shadowAlpha, float insideAlpha) {
        Color shadow = new Color(0.0f, 0.0f, 0.0f, shadowAlpha);
        Color highlight = new Color(1.0f, 1.0f, 1.0f, highlightAlpha);
        Color inside = new Color(0.0f, 0.0f, 0.0f, insideAlpha);
        DrawingTools.drawShadowedBox(g, r, highlight, shadow, inside);
    }

    public static void adjustAlpha(BufferedImage image, float alpha) {
        int n = image.getWidth() * image.getHeight();
        int[] pixels = new int[n];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
        int a = (int)(255.0f * alpha);
        for (int i = 0; i < n; ++i) {
            pixels[i] = a << 24 | pixels[i] & 0xFFFFFF;
        }
        image.setRGB(0, 0, image.getWidth(), image.getHeight(), pixels, 0, image.getWidth());
    }
}

