/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.image;

import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.image.MemoryImageSource;
import java.io.File;
import java.io.IOException;

public class ImageFrame
extends Frame {
    private static final long serialVersionUID = 2095764397849922116L;
    private int left = -1;
    private int top;
    private Image image;

    public ImageFrame() {
        this.setLayout(null);
        this.setSize(100, 100);
    }

    public void setImage(File file) throws IOException {
        Image image = this.getToolkit().getImage(file.getAbsolutePath());
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (tracker.statusID(0, true) != 8) {
            throw new IOException("Could not load: " + file + " " + tracker.statusID(0, true));
        }
        this.setTitle(file.getName());
        this.setImage(image);
    }

    public void setImage(Image image) {
        this.image = image;
        this.setVisible(true);
    }

    public void setImage(int[] palette, int[][] pixels) {
        int w = pixels.length;
        int h = pixels[0].length;
        int[] pix = new int[w * h];
        int x = w;
        while (x-- > 0) {
            int y = h;
            while (y-- > 0) {
                pix[y * w + x] = palette[pixels[x][y]];
            }
        }
        this.setImage(w, h, pix);
    }

    public void setImage(int[][] pixels) {
        int w = pixels.length;
        int h = pixels[0].length;
        int[] pix = new int[w * h];
        int x = w;
        while (x-- > 0) {
            int y = h;
            while (y-- > 0) {
                pix[y * w + x] = pixels[x][y];
            }
        }
        this.setImage(w, h, pix);
    }

    public void setImage(int w, int h, int[] pix) {
        this.setImage(this.createImage(new MemoryImageSource(w, h, pix, 0, w)));
    }

    public Image getImage() {
        return this.image;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.left == -1) {
            Insets insets = this.getInsets();
            this.left = insets.left;
            this.top = insets.top;
            this.setSize(this.image.getWidth(null) + this.left + insets.right, this.image.getHeight(null) + this.top + insets.bottom);
        }
        g.drawImage(this.image, this.left, this.top, this);
    }
}

