/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.input;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.Keyboard;
import org.jagatoo.input.devices.components.Keys;
import org.openmali.vecmath2.Point3f;
import org.xith3d.loop.Updatable;
import org.xith3d.loop.Updater;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.physics.util.Placeable;

public class EightDirectionsMovement
implements Updatable {
    private final Keyboard keyboard;
    private final Placeable placeable;
    private float speed;

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public final float getSpeed() {
        return this.speed;
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        float realSpeed = this.speed * timingMode.getSecondsAsFloat(frameTime);
        float xDiff = 0.0f;
        float yDiff = 0.0f;
        if (this.keyboard.isKeyPressed(Keys.LEFT)) {
            xDiff -= realSpeed;
        }
        if (this.keyboard.isKeyPressed(Keys.RIGHT)) {
            xDiff += realSpeed;
        }
        if (this.keyboard.isKeyPressed(Keys.DOWN)) {
            yDiff -= realSpeed;
        }
        if (this.keyboard.isKeyPressed(Keys.UP)) {
            yDiff += realSpeed;
        }
        Point3f pos = Point3f.fromPool();
        this.placeable.getPosition(pos);
        pos.addX(xDiff);
        pos.addY(yDiff);
        this.placeable.setPosition(pos);
        Point3f.toPool(pos);
    }

    public EightDirectionsMovement(Keyboard keyboard, Placeable placeable, float speed, Updater updater) {
        if (keyboard == null) {
            if (!InputSystem.hasInstance()) {
                throw new Error("No InputSystem registered.");
            }
            keyboard = InputSystem.getInstance().getKeyboard();
            if (keyboard == null) {
                throw new Error("No Keyboard registered at the InputSystem.");
            }
        }
        this.placeable = placeable;
        this.keyboard = keyboard;
        this.speed = speed;
        updater.addUpdatable(this);
    }

    public EightDirectionsMovement(Placeable placeable, float speed, Updater updater) {
        this(null, placeable, speed, updater);
    }
}

