/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.input;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.Keyboard;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.Keys;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.OperationScheduler;
import org.xith3d.loop.opscheduler.impl.ScheduledOperationImpl;

public class KeyAdjustableFloat
extends ScheduledOperationImpl {
    private final Keyboard keyboard;
    private final Key vkDown;
    private final Key vkUp;
    private final Key vkDisp;
    private final float speed;
    private float value;

    public void setValue(float value) {
        this.value = value;
    }

    public void setValue(Float value) {
        this.value = value.floatValue();
    }

    public final float getValue() {
        return this.value;
    }

    public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
        float diff = timingMode.getSecondsAsFloat(frameTime) * this.speed;
        if (this.keyboard.isKeyPressed(this.vkDown)) {
            this.value -= diff;
        }
        if (this.keyboard.isKeyPressed(this.vkUp)) {
            this.value += diff;
        }
        if (this.keyboard.isKeyPressed(this.vkDisp)) {
            System.out.println("Value = " + this.value);
        }
    }

    public KeyAdjustableFloat(Key vkDown, Key vkUp, Key vkDisp, float speed, OperationScheduler opSched) {
        super(true);
        if (!InputSystem.hasInstance()) {
            throw new Error("No InputSystem registered.");
        }
        this.keyboard = InputSystem.getInstance().getKeyboard();
        if (this.keyboard == null) {
            throw new Error("No Keyboard registered at the InputSystem.");
        }
        this.vkDown = vkDown;
        this.vkUp = vkUp;
        this.vkDisp = vkDisp;
        this.speed = speed;
        opSched.scheduleOperation(this);
    }

    public KeyAdjustableFloat(Key vkDown, Key vkUp, float speed, OperationScheduler opSched) {
        this(vkDown, vkUp, Keys.ESCAPE, speed, opSched);
    }
}

