/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.noise;

import java.util.Random;

public class Noise {
    public static final int B = 256;
    public static final int BM = 255;
    public static final int N = 4096;
    public static final int NP = 12;
    public static final int NM = 4095;
    private Random rgen = new Random();
    private double rseed;
    private double[] vec;
    private int[] p;
    private double[][] g3;
    private double[][] g2;
    private double[] g1;

    public Noise() {
        this.init_noise();
    }

    public Noise(double seed) {
        this.setSeed(seed);
        this.init_noise();
    }

    public void setSeed(double s) {
        this.rseed = s;
        this.rgen.setSeed(Double.doubleToLongBits(this.rseed));
        this.init_noise();
    }

    public double getSeed() {
        return this.rseed;
    }

    public double bias(double a, double b) {
        return Math.pow(a, Math.log(b) / Math.log(0.5));
    }

    public double gain(double a, double b) {
        double p = Math.log(1.0 - b) / Math.log(0.5);
        if (a < 0.001) {
            return 0.0;
        }
        if (a > 0.999) {
            return 1.0;
        }
        if (a < 0.5) {
            return Math.pow(2.0 * a, p) / 2.0;
        }
        return 1.0 - Math.pow(2.0 * (1.0 - a), p) / 2.0;
    }

    public double turbulence(double[] v, double freq) {
        if (this.vec == null) {
            this.vec = new double[3];
        }
        double t = 0.0;
        while (freq >= 1.0) {
            this.vec[0] = freq * v[0];
            this.vec[1] = freq * v[1];
            this.vec[2] = freq * v[2];
            t += Math.abs(this.noise3(this.vec)) / freq;
            freq /= 2.0;
        }
        return t;
    }

    private void normalize2(double[] v) {
        double s = Math.sqrt(v[0] * v[0] + v[1] * v[1]);
        v[0] = v[0] / s;
        v[1] = v[1] / s;
    }

    private void normalize3(double[] v) {
        double s = Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
        v[0] = v[0] / s;
        v[1] = v[1] / s;
        v[2] = v[2] / s;
    }

    private void init_noise() {
        int j;
        int i;
        this.p = new int[514];
        this.g3 = new double[514][3];
        this.g2 = new double[514][2];
        this.g1 = new double[514];
        for (i = 0; i < 256; ++i) {
            this.p[i] = i;
            this.g1[i] = this.rgen.nextDouble() * 2.0 - 1.0;
            for (j = 0; j < 2; ++j) {
                this.g2[i][j] = this.rgen.nextDouble() * 2.0 - 1.0;
            }
            this.normalize2(this.g2[i]);
            for (j = 0; j < 3; ++j) {
                this.g3[i][j] = this.rgen.nextDouble() * 2.0 - 1.0;
            }
            this.normalize3(this.g3[i]);
        }
        while (--i > 0) {
            j = (int)(this.rgen.nextDouble() * 256.0);
            int k = this.p[i];
            this.p[i] = this.p[j];
            this.p[j] = k;
        }
        for (i = 0; i < 258; ++i) {
            this.p[256 + i] = this.p[i];
            this.g1[256 + i] = this.g1[i];
            for (j = 0; j < 2; ++j) {
                this.g2[256 + i][j] = this.g2[i][j];
            }
            for (j = 0; j < 3; ++j) {
                this.g3[256 + i][j] = this.g3[i][j];
            }
        }
    }

    public double s_curve(double t) {
        return t * t * (3.0 - 2.0 * t);
    }

    public double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    public double noise1(double arg) {
        double t = arg + 4096.0;
        int bx0 = (int)t & 0xFF;
        int bx1 = bx0 + 1 & 0xFF;
        double rx0 = t - (double)((int)t);
        double rx1 = rx0 - 1.0;
        double sx = this.s_curve(rx0);
        double u = rx0 * this.g1[this.p[bx0]];
        double v = rx1 * this.g1[this.p[bx1]];
        return this.lerp(sx, u, v);
    }

    public double noise2(double[] vec) {
        double t = vec[0] + 4096.0;
        int bx0 = (int)t & 0xFF;
        int bx1 = bx0 + 1 & 0xFF;
        double rx0 = t - (double)((int)t);
        double rx1 = rx0 - 1.0;
        t = vec[1] + 4096.0;
        int by0 = (int)t & 0xFF;
        int by1 = by0 + 1 & 0xFF;
        double ry0 = t - (double)((int)t);
        double ry1 = ry0 - 1.0;
        int i = this.p[bx0];
        int j = this.p[bx1];
        int b00 = this.p[i + by0];
        int b10 = this.p[j + by0];
        int b01 = this.p[i + by1];
        int b11 = this.p[j + by1];
        double sx = this.s_curve(rx0);
        double sy = this.s_curve(ry0);
        double[] q = this.g2[b00];
        double u = rx0 * q[0] + ry0 * q[1];
        q = this.g2[b10];
        double v = rx1 * q[0] + ry0 * q[1];
        double a = this.lerp(sx, u, v);
        q = this.g2[b01];
        u = rx0 * q[0] + ry1 * q[1];
        q = this.g2[b11];
        v = rx1 * q[0] + ry1 * q[1];
        double b = this.lerp(sx, u, v);
        return this.lerp(sy, a, b);
    }

    public double noise3(double[] vec) {
        double t = vec[0] + 4096.0;
        int bx0 = (int)t & 0xFF;
        int bx1 = bx0 + 1 & 0xFF;
        double rx0 = t - (double)((int)t);
        double rx1 = rx0 - 1.0;
        t = vec[1] + 4096.0;
        int by0 = (int)t & 0xFF;
        int by1 = by0 + 1 & 0xFF;
        double ry0 = t - (double)((int)t);
        double ry1 = ry0 - 1.0;
        t = vec[2] + 4096.0;
        int bz0 = (int)t & 0xFF;
        int bz1 = bz0 + 1 & 0xFF;
        double rz0 = t - (double)((int)t);
        double rz1 = rz0 - 1.0;
        int i = this.p[bx0];
        int j = this.p[bx1];
        int b00 = this.p[i + by0];
        int b10 = this.p[j + by0];
        int b01 = this.p[i + by1];
        int b11 = this.p[j + by1];
        t = this.s_curve(rx0);
        double sy = this.s_curve(ry0);
        double sz = this.s_curve(rz0);
        double[] q = this.g3[b00 + bz0];
        double u = rx0 * q[0] + ry0 * q[1] + rz0 * q[2];
        q = this.g3[b10 + bz0];
        double v = rx1 * q[0] + ry0 * q[1] + rz0 * q[2];
        double a = this.lerp(t, u, v);
        q = this.g3[b01 + bz0];
        u = rx0 * q[0] + ry1 * q[1] + rz0 * q[2];
        q = this.g3[b11 + bz0];
        v = rx1 * q[0] + ry1 * q[1] + rz0 * q[2];
        double b = this.lerp(t, u, v);
        double c = this.lerp(sy, a, b);
        q = this.g3[b00 + bz1];
        u = rx0 * q[0] + ry0 * q[1] + rz1 * q[2];
        q = this.g3[b10 + bz1];
        v = rx1 * q[0] + ry0 * q[1] + rz1 * q[2];
        a = this.lerp(t, u, v);
        q = this.g3[b01 + bz1];
        u = rx0 * q[0] + ry1 * q[1] + rz1 * q[2];
        q = this.g3[b11 + bz1];
        v = rx1 * q[0] + ry1 * q[1] + rz1 * q[2];
        b = this.lerp(t, u, v);
        double d = this.lerp(sy, a, b);
        return this.lerp(sz, c, d);
    }

    public double noise(double[] vec, int len) {
        switch (len) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return this.noise1(vec[0]);
            }
            case 2: {
                return this.noise2(vec);
            }
        }
        return this.noise3(vec);
    }
}

