/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.properties;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.xith3d.utility.properties.Property;
import org.xith3d.utility.properties.PropertyWriter;

public class FilePropertyWriter
implements PropertyWriter {
    private PrintStream prnout;
    private int indent;

    private void writeIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.prnout.print(" ");
        }
    }

    public void write(String name, int value) {
        this.writeIndent();
        this.prnout.print(name + ":int=");
        this.prnout.println(value);
    }

    public void write(String name, float value) {
        this.writeIndent();
        this.prnout.print(name + ":float=");
        this.prnout.println(value);
    }

    public void write(String name, double value) {
        this.writeIndent();
        this.prnout.print(name + ":double=");
        this.prnout.println(value);
    }

    public void write(String name, String value) {
        this.writeIndent();
        this.prnout.print(name + ":string=");
        this.prnout.println(value);
    }

    public void write(Property value) {
        this.writeIndent();
        this.prnout.print("<");
        this.prnout.print(value.getName());
        this.prnout.print(":");
        this.prnout.print(value.getClass().getName());
        this.prnout.println(">");
        this.indent += 3;
        this.indent -= 3;
        this.prnout.print("</");
        this.prnout.print(value.getName());
        this.prnout.println(">");
    }

    void close() {
        this.prnout.flush();
        this.prnout.close();
    }

    public FilePropertyWriter(String filename) throws IOException {
        this.prnout = new PrintStream(new BufferedOutputStream(new FileOutputStream(filename)));
        this.indent = 0;
    }
}

