/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.utility.screenshots;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import org.jagatoo.util.nio.BufferUtils;

public class ScreenshotCreator
implements Runnable {
    private static final int GL_RGB = 6407;
    private static final int GL_RGBA = 6408;
    private Format format;
    private ByteBuffer byteBuffer;
    private BufferedImage image;
    private File targetFile;

    public Format getFormat() {
        return this.format;
    }

    public int getGLFormat() {
        return this.format.getIntGL();
    }

    public ByteBuffer getBuffer() {
        return this.byteBuffer;
    }

    private BufferedImage convertRGB() {
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        int[] pixelInts = new int[width * height];
        int p = width * height * 3;
        int i = 0;
        int bytesPerRow = width * 3;
        for (int row = height - 1; row >= 0; --row) {
            int q = p = row * bytesPerRow;
            for (int col = 0; col < width; ++col) {
                byte iR = this.byteBuffer.get(q++);
                byte iG = this.byteBuffer.get(q++);
                byte iB = this.byteBuffer.get(q++);
                pixelInts[i++] = 0xFF000000 | (iR & 0xFF) << 16 | (iG & 0xFF) << 8 | iB & 0xFF;
            }
        }
        this.image.setRGB(0, 0, this.image.getWidth(), this.image.getHeight(), pixelInts, 0, this.image.getWidth());
        return this.image;
    }

    private BufferedImage convertRGBA() {
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        int bytesPerRow = width * 4;
        int p = width * height * 4;
        for (int row = height - 1; row >= 0; --row) {
            int q = p = row * bytesPerRow;
            for (int col = 0; col < width; ++col) {
                byte iR = this.byteBuffer.get(q++);
                byte iG = this.byteBuffer.get(q++);
                byte iB = this.byteBuffer.get(q++);
                byte iA = this.byteBuffer.get(q++);
                int pixelInt = 0xFF000000 | (iA & 0xFF) << 24 | (iR & 0xFF) << 16 | (iG & 0xFF) << 8 | iB & 0xFF;
                this.image.setRGB(col, row, pixelInt);
            }
        }
        return this.image;
    }

    public void run() {
        if (this.format == Format.RGB) {
            this.convertRGB();
        } else {
            this.convertRGBA();
        }
        if (this.targetFile != null) {
            try {
                ImageIO.write((RenderedImage)this.image, "PNG", this.targetFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public BufferedImage createScreenshot() {
        if (this.targetFile == null) {
            if (this.format == Format.RGB) {
                return this.convertRGB();
            }
            return this.convertRGBA();
        }
        new Thread(this).start();
        return null;
    }

    public void createScreenshot(File targetFile) {
        this.targetFile = targetFile;
        new Thread(this).start();
    }

    public ScreenshotCreator(int width, int height, Format format, File targetFile) {
        this.format = format;
        int bytesPerPixel = 0;
        if (format == Format.RGB) {
            bytesPerPixel = 3;
        } else if (format == Format.RGBA) {
            bytesPerPixel = 4;
        } else {
            throw new IllegalArgumentException("Either RGB or RGBA are allowed as format.");
        }
        this.byteBuffer = BufferUtils.createByteBuffer(width * height * bytesPerPixel);
        this.image = new BufferedImage(width, height, format.getBufferedImageFormat());
        this.targetFile = targetFile;
    }

    public ScreenshotCreator(int width, int height, Format format) {
        this(width, height, format, null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        RGB(6407),
        RGBA(6408);

        private int int_GL;

        public int getIntGL() {
            return this.int_GL;
        }

        public int getBufferedImageFormat() {
            if (this == RGB) {
                return 1;
            }
            return 2;
        }

        public static Format getFromGL(int intGL) {
            if (intGL == 6407) {
                return RGB;
            }
            if (intGL == 6408) {
                return RGBA;
            }
            throw new IllegalArgumentException("Either RGB or RGBA are allowed as format.");
        }

        private Format(int int_GL) {
            this.int_GL = int_GL;
        }
    }
}

