/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.w3g;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.opengl.enums.FaceCullMode;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loaders.texture.TextureLoader;
import org.xith3d.loop.InputAdapterRenderLoop;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DFactory;
import org.xith3d.render.config.CanvasConstructionInfo;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.GroupNode;
import org.xith3d.scenegraph.PointLight;
import org.xith3d.scenegraph.Shape3D;
import org.xith3d.scenegraph.TexCoordGeneration;
import org.xith3d.scenegraph.TriangleArray;
import org.xith3d.test.Xith3DTest;
import org.xith3d.test.loaders.util.RotatingModel;

public class ModifyModels
extends InputAdapterRenderLoop {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private void loadModel(ResourceLocator resLoc, GroupNode parentGroup, Animator animator) throws Exception {
        Model model = ModelLoader.getInstance().loadModel(resLoc.getResource("models/galleon.obj"));
        Shape3D shape = model.findFirst(Shape3D.class);
        ((TriangleArray)shape.getGeometry()).calculateFaceNormals();
        shape.getAppearance().setTexCoordGeneration(new TexCoordGeneration(TexCoordGeneration.SPHERE_MAP, TexCoordGeneration.TEXTURE_COORDINATE_2));
        shape.getAppearance().setColor(1.0f, 0.3f, 0.5f);
        shape.getAppearance().setTexture(TextureLoader.getInstance().getTexture("textures/rustycan.jpg"));
        shape.getAppearance().setFaceCullMode(FaceCullMode.NONE);
        RotatingModel rotModel = new RotatingModel(model, 1.0f);
        parentGroup.addChild(rotModel);
        animator.addAnimatableObject(rotModel);
    }

    public ModifyModels(CanvasConstructionInfo canvasInfo) throws Exception {
        Xith3DEnvironment env = new Xith3DEnvironment(5.0f, 1.0f, 80.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, this);
        Canvas3D canvas = Canvas3DFactory.create(canvasInfo);
        canvas.enableLighting();
        env.addCanvas(canvas);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        ResourceLocator resLoc = ResourceLocator.create("demo/");
        BranchGroup scene = env.addPerspectiveBranch().getBranchGroup();
        this.loadModel(resLoc, scene, this.getAnimator());
        scene.addChild(new PointLight(1.0f, 0.8f, 0.2f, 2.0f, 2.0f, 15.0f, 0.001f));
        this.begin();
    }

    public static void main(String[] argv) throws Exception {
        new ModifyModels(new CanvasConstructionInfo(Xith3DTest.DEFAULT_DISPLAY_MODE, Xith3DTest.DEFAULT_FULLSCREEN, "ModifyModelsTest"));
    }
}

