/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.xin;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.InputAdapterRenderLoop;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DFactory;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.Transform3D;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.utility.interpolate.AngleInterpolater;

public class Chapter07a
extends InputAdapterRenderLoop {
    private Transform3D t3d;
    private TransformGroup tg;
    private AngleInterpolater angleX;
    private AngleInterpolater angleY;

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createScene() {
        Cube cube = new Cube(3.0f, "stone.jpg");
        this.t3d = new Transform3D();
        this.tg = new TransformGroup(this.t3d);
        this.tg.addChild(cube);
        return new BranchGroup((Node)this.tg);
    }

    protected void onRenderLoopStarted() {
        this.angleX = new AngleInterpolater(1.0f);
        this.angleY = new AngleInterpolater(1.0f);
        this.angleX.startIncreasing(this.getGameMicroTime());
        this.angleY.startIncreasing(this.getGameMicroTime());
    }

    protected void prepareNextFrame(long gameTime, long frameTime, UpdatingThread.TimingMode tm) {
        super.prepareNextFrame(gameTime, frameTime, tm);
        long micros = tm.getMicroSeconds(gameTime);
        this.t3d.rotXYZ(this.angleX.getValue(micros), this.angleY.getValue(micros), 0.0f);
        this.tg.setTransform(this.t3d);
    }

    public Chapter07a() throws Exception {
        super(120.0f);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        Canvas3D canvas = Canvas3DFactory.createWindowed(800, 600, "Animation - Rotation");
        env.addCanvas(canvas);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        ResourceLocator resLoc = ResourceLocator.create("test-resources/");
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch(this.createScene());
    }

    public static void main(String[] args) throws Exception {
        Chapter07a rl = new Chapter07a();
        rl.begin();
    }
}

