/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.xin;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.InputAdapterRenderLoop;
import org.xith3d.loop.UpdatingThread;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.loop.opscheduler.ScheduledOperation;
import org.xith3d.loop.opscheduler.impl.ScheduledOperationImpl;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DFactory;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;

public class Chapter08a
extends InputAdapterRenderLoop {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createScene(Animator animator) {
        Cube cube = new Cube(3.0f, "stone.jpg");
        TransformationDirectives rotDirecs = new TransformationDirectives(0.3f, 0.2f, 0.0f);
        RotatableGroup rg = new RotatableGroup(rotDirecs);
        rg.addChild(cube);
        animator.addAnimatableObject(rg);
        return new BranchGroup((Node)rg);
    }

    public Chapter08a() throws Exception {
        super(120.0f);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        Canvas3D canvas = Canvas3DFactory.createWindowed(800, 600, "Animation - Rotation");
        env.addCanvas(canvas);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        ResourceLocator resLoc = ResourceLocator.create("test-resources/");
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch(this.createScene(this.getAnimator()));
        this.getOperationScheduler().scheduleOperation(new MyOperation());
        this.getOperationScheduler().scheduleOperation(new MyOperation2());
    }

    public static void main(String[] args) throws Exception {
        Chapter08a rl = new Chapter08a();
        rl.begin();
    }

    private class MyOperation2
    extends ScheduledOperationImpl {
        public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
            System.out.println("This MyOperation2 is executed!");
        }

        public MyOperation2() {
            super(true);
        }
    }

    private class MyOperation
    implements ScheduledOperation {
        private boolean isAlive = true;

        private MyOperation() {
        }

        public boolean isPersistent() {
            return true;
        }

        public void setAlive(boolean alive) {
            this.isAlive = alive;
        }

        public boolean isAlive() {
            return this.isAlive;
        }

        public void update(long gameTime, long frameTime, UpdatingThread.TimingMode timingMode) {
            System.out.println("This MyOperation is executed!");
        }
    }
}

