/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.xin;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loaders.models.Model;
import org.xith3d.loaders.models.ModelLoader;
import org.xith3d.loop.InputAdapterRenderLoop;
import org.xith3d.loop.opscheduler.Animator;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DFactory;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Node;
import org.xith3d.schedops.movement.RotatableGroup;
import org.xith3d.schedops.movement.TransformationDirectives;

public class Chapter11
extends InputAdapterRenderLoop {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case F1: {
                this.getXith3DEnvironment().getScreenshotEngine().takeScreenshot(false);
                break;
            }
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createScene(ResourceLocator resLoc, Animator animator) throws Exception {
        Model model = ModelLoader.getInstance().loadModel(resLoc.getResource("models/jeep.obj"));
        TransformationDirectives rotDirecs = new TransformationDirectives(0.3f, 0.2f, 0.0f);
        RotatableGroup rg = new RotatableGroup(rotDirecs);
        rg.addChild(model);
        animator.addAnimatableObject(rg);
        return new BranchGroup((Node)rg);
    }

    public Chapter11() throws Exception {
        super(120.0f);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        Canvas3D canvas = Canvas3DFactory.createWindowed(800, 600, "Model Loading");
        canvas.disableLighting();
        env.addCanvas(canvas);
        env.getView().setPosition(0.0f, 0.0f, 2.0f);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        ResourceLocator resLoc = ResourceLocator.create("test-resources/");
        resLoc.createAndAddTSL("textures");
        env.addPerspectiveBranch(this.createScene(resLoc, this.getAnimator()));
    }

    public static void main(String[] args) throws Exception {
        Chapter11 rl = new Chapter11();
        rl.begin();
    }
}

