/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.xin;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.InputAdapterRenderLoop;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DFactory;
import org.xith3d.resources.ModelResourceRequest;
import org.xith3d.resources.ResBag;
import org.xith3d.resources.ResourceBag;
import org.xith3d.resources.ResourceLoader;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.resources.TextureResourceRequest;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.StaticTransform;
import org.xith3d.scenegraph.Texture;
import org.xith3d.scenegraph.primitives.Cube;

public class Chapter12
extends InputAdapterRenderLoop {
    public static final String RES_MODEL1 = "MODEL1";
    public static final String RES_MODEL2 = "MODEL2";
    public static final String RES_TEX1 = "TEXTURE1";
    public static final String RES_TEX15 = "TEXTURE15";

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private ResourceBag loadResources() throws Exception {
        ResourceLocator resLoc = ResourceLocator.create("test-resources/");
        resLoc.useAsSingletonInstance();
        resLoc.createAndAddTSL("textures");
        ResourceLoader loader = new ResourceLoader(resLoc);
        loader.addRequest(new ModelResourceRequest("models/jeep.obj", RES_MODEL1));
        loader.addRequest(new ModelResourceRequest("models/galleon.obj", RES_MODEL2));
        loader.addRequest(new TextureResourceRequest("stone.jpg", RES_TEX1));
        loader.addRequest(new TextureResourceRequest("wood.jpg", RES_TEX15));
        ResourceBag resBag = loader.loadResources();
        ResourceBag.setSingletonInstance(resBag);
        return resBag;
    }

    private BranchGroup createScene() {
        Texture tex1 = ResourceBag.getInstance().getTexture(RES_TEX1);
        Cube cube1 = new Cube(3.0f, tex1);
        StaticTransform.translate(cube1, -2.0f, 0.0f, 0.0f);
        Texture tex2 = ResBag.getTexture(RES_TEX15);
        Cube cube2 = new Cube(3.0f, tex2);
        StaticTransform.translate(cube2, 2.0f, 0.0f, 0.0f);
        BranchGroup scene = new BranchGroup();
        scene.addChild(cube1);
        scene.addChild(cube2);
        return scene;
    }

    public Chapter12() throws Exception {
        super(120.0f);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        Canvas3D canvas = Canvas3DFactory.createWindowed(800, 600, "Resource loading");
        env.addCanvas(canvas);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        this.loadResources();
        env.addPerspectiveBranch(this.createScene());
    }

    public static void main(String[] args) throws Exception {
        Chapter12 rl = new Chapter12();
        rl.begin();
    }
}

