/*
 * Decompiled with CFR 0.152.
 */
package org.xith3d.xin;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.openmali.FastMath;
import org.xith3d.base.Xith3DEnvironment;
import org.xith3d.loop.InputAdapterRenderLoop;
import org.xith3d.render.BaseRenderPassConfig;
import org.xith3d.render.Canvas3D;
import org.xith3d.render.Canvas3DFactory;
import org.xith3d.resources.ResourceLocator;
import org.xith3d.scenegraph.BranchGroup;
import org.xith3d.scenegraph.Node;
import org.xith3d.scenegraph.SceneGraph;
import org.xith3d.scenegraph.TransformGroup;
import org.xith3d.scenegraph.View;
import org.xith3d.scenegraph.primitives.Cube;
import org.xith3d.scenegraph.primitives.Rectangle;

public class Chapter14
extends InputAdapterRenderLoop {
    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        switch (key.getKeyID()) {
            case ESCAPE: {
                this.end();
            }
        }
    }

    private BranchGroup createMainScene() {
        Cube cube = new Cube(3.0f, "stone.jpg");
        TransformGroup tg = new TransformGroup();
        tg.getTransform().rotY(FastMath.toRad(45.0f));
        tg.addChild(cube);
        return new BranchGroup((Node)tg);
    }

    private BranchGroup createParallelScene() {
        Rectangle rect = new Rectangle(0.5f, 0.2f, "precision.png");
        return new BranchGroup(rect);
    }

    private void createSceneGraph(SceneGraph sg) {
        BaseRenderPassConfig scenePassConfig = new BaseRenderPassConfig(View.ProjectionPolicy.PERSPECTIVE_PROJECTION);
        sg.addBranchGraph(this.createMainScene(), scenePassConfig);
        BaseRenderPassConfig paraPassConfig = new BaseRenderPassConfig(View.ProjectionPolicy.PARALLEL_PROJECTION);
        sg.addBranchGraph(this.createParallelScene(), paraPassConfig);
    }

    public Chapter14() throws Exception {
        super(120.0f);
        Xith3DEnvironment env = new Xith3DEnvironment(this);
        Canvas3D canvas = Canvas3DFactory.createWindowed(800, 600, "Multipass Rendering");
        env.addCanvas(canvas);
        InputSystem.getInstance().registerNewKeyboardAndMouse(canvas.getPeer());
        ResourceLocator resLoc = ResourceLocator.create("test-resources/");
        resLoc.createAndAddTSL("textures");
        this.createSceneGraph(env);
    }

    public static void main(String[] args) throws Exception {
        Chapter14 rl = new Chapter14();
        rl.begin();
    }
}

