import java.io.*;
import java.net.*;

public class RemoteMonitorService extends Agent {
    
    private Socket socket;
    private PrintWriter out;
    
    public RemoteMonitorService (Socket socket) {
        this.socket = socket;
        try {
            out = new PrintWriter(socket.getOutputStream(),true);
        } catch (Exception ee) {
        }            
        attachTimer(100);
        start();
    }

    public void senseSelectAct() throws Exception {
        Float compass = (Float) read("Compass",new Float(-1000.0f));
        Boolean bump = (Boolean) read("Bump",new Boolean(false));
        double[] stop = {0.0,0.0,0.0,0.0, 0.0,0.0,0.0,0.0, 0.0,0.0,0.0,0.0}; 
        double[] sonar = (double[]) read("Sonar",stop);
        Float x = (Float) read("x",new Float(0.0f));
        Float y = (Float) read("y",new Float(0.0f));
        try {
            out.println("Compass = "+compass.toString());
            out.println("Bump = "+bump.toString());
            out.print("Sonar =");
            for (int i=0; i<12; i++) out.print(" "+sonar[i]);
            out.println();
            out.println("X = "+x.toString());
            out.println("Y = "+y.toString());
        } catch (Exception ee) {
            quit();
        }
    }

}

