from pyicubsim import iCubEmotion
from agentspace import space, Agent
import numpy as np
import time

emotion = iCubEmotion()

class LipsAgent(Agent):

    def init(self):
        self.active = False
        self.smiling = False
        emotion.set('neu')
        self.attach_timer(0.15)
        
    def senseSelectAct(self):
        
        if space(default=False)["speaking"]:
            if self.active:
                emotion.set('hap' if self.smiling else 'neu')
                self.active = False
            else: 
                emotion.set('cun')
                self.active = True
        else:
            if self.active:
                emotion.set('hap' if self.smiling else 'neu')
                self.active = False

        if space(default=False)["smile"]:
            if not self.smiling:
                emotion.set('hap')
                self.smiling = True
            elif np.random.rand(1) < 0.05:
                space["smile"] = False
        else:
            if self.smiling:
                emotion.set('neu')
                self.smiling = False
        
if __name__ == "__main__":  
    agent = LipsAgent()
    time.sleep(1)
    space["smile"] = True
    time.sleep(2)
    space["speaking"] = True
    time.sleep(3)
    space["speaking"] = False
    time.sleep(2)
    space["smile"] = False
    time.sleep(2)
    agent.stop()
