from agentspace import space
import signal 
import os
import time

def signal_handler(signal, frame):
    os._exit(0)

signal.signal(signal.SIGINT, signal_handler)

from speakeragent import SpeakerAgent
from lipsagent import LipsAgent
from controlagent import ControlAgent

print('starting')
SpeakerAgent() # reads "text-to-speak" and writes "speaking"
time.sleep(1)
LipsAgent() # reads "speaking" and "smile"
time.sleep(1)
ControlAgent() # reads "entered" and writes "smile", "text-to-speak" and moves motors
time.sleep(1)
print('started')

import tkinter as tk

class App(): # writes "entered"
    def __init__(self, master):
        self.buttonText = tk.StringVar()
        self.buttonText.set('Submit the entered text')
        self.button = tk.Button(main, textvariable=self.buttonText)
        self.button.bind("<Button-1>", self.submit)
        self.button.pack()
        self.txt = tk.Text(main, height = 1, width = 60, bg = "light yellow")
        self.txt.pack()

    def submit(self, event):
        text = self.txt.get(0.0,tk.END)
        space['entered'] = text
        self.txt.delete(0.0,tk.END)

main = tk.Tk()
app = App(main)
main.mainloop()
