import os
import sys
from agentspace import Agent, space, Trigger
import time

class SpeakerAgent(Agent):

    def speak(self,text):
        print(text)
        filename = str(time.time())+'.txt'
        file = open(filename,'wb') 
        file.write(bytes(text,'utf-16')) 
        file.close() 
        os.environ["ESPEAK_DATA_PATH"] = "." 
        os.system('espeak -v EN -b4 -f '+filename)
        os.remove(filename)

    def init(self):
        space.attach_trigger("text-to-speak",self,Trigger.NAMES_AND_VALUES)
        
    def senseSelectAct(self):
        _, text = self.triggered()
        space["speaking"] = True
        self.speak(text)
        space["speaking"] = False

if __name__ == "__main__":  
    agent = SpeakerAgent()
    time.sleep(1)
    space["text-to-speak"] = 'I am a robot'
    time.sleep(2)
    agent.stop()
