/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import net.java.dev.joode.Body;
import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.SimState;
import net.java.dev.joode.WorldBodyListener;
import net.java.dev.joode.WorldJointListener;
import net.java.dev.joode.WorldListener;
import net.java.dev.joode.WorldStepListener;
import net.java.dev.joode.collision.ContactParameters;
import net.java.dev.joode.force.WorldForce;
import net.java.dev.joode.joint.Joint;
import net.java.dev.joode.joint.JointContact;
import net.java.dev.joode.stepper.AccurateSimpleStepper;
import net.java.dev.joode.stepper.EulerStepper;
import net.java.dev.joode.stepper.QuickStepper;
import net.java.dev.joode.stepper.RungeKuttaOrder4Stepper;
import net.java.dev.joode.stepper.SimpleStepper;
import net.java.dev.joode.stepper.StepUtils;
import org.jagatoo.util.lists.ChainedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class World
implements SimState {
    private float time;
    private static final long serialVersionUID = -725981870790247791L;
    private final ChainedList<Body> bodies;
    private final ChainedList<Joint> joints;
    private final ChainedList<Joint> jointContacts;
    private final LinkedList<WorldForce> forces;
    private final ArrayList<WorldBodyListener> bodyListeners;
    private final ArrayList<WorldJointListener> jointListeners;
    private final ArrayList<WorldStepListener> stepListeners;
    private int stepFunction = 0;
    private Object userData;
    private float global_erp = 0.2f;
    private float global_cfm = 1.0E-6f;
    private ContactParameters contactParams;

    public World(Object userData) {
        this.userData = userData;
        this.bodies = new ChainedList();
        this.joints = new ChainedList();
        this.jointContacts = new ChainedList();
        this.forces = new LinkedList();
        this.contactParams = new ContactParameters();
        this.bodyListeners = new ArrayList();
        this.jointListeners = new ArrayList();
        this.stepListeners = new ArrayList();
    }

    public World() {
        this(null);
    }

    public final float getTime() {
        return this.time;
    }

    public final void addBody(Body body) {
        this.bodies.add(body);
        body.setWorld(this);
        int i = 0;
        while (i < this.bodyListeners.size()) {
            this.bodyListeners.get(i).bodyAdded(this, body);
            ++i;
        }
    }

    public final void removeBody(Body body) {
        this.bodies.remove(body);
        body.setWorld(null);
        int i = 0;
        while (i < this.bodyListeners.size()) {
            this.bodyListeners.get(i).bodyRemoved(this, body);
            ++i;
        }
    }

    public final int getNumBodies() {
        return this.bodies.size();
    }

    public final Body getFirstBody() {
        return this.bodies.getHead();
    }

    @Deprecated
    public final Body getBody(int i) {
        return (Body)this.bodies.get(i);
    }

    public final void addJoint(Joint joint) {
        joint.setWorld(this);
        if (!(joint instanceof JointContact)) {
            this.joints.add(joint);
            int i = 0;
            while (i < this.jointListeners.size()) {
                this.jointListeners.get(i).jointAdded(this, joint);
                ++i;
            }
        } else {
            this.jointContacts.add(joint);
        }
    }

    public final void removeJoint(Joint joint) {
        joint.setWorld(null);
        if (!(joint instanceof JointContact)) {
            this.joints.remove(joint);
            int i = 0;
            while (i < this.jointListeners.size()) {
                this.jointListeners.get(i).jointRemoved(this, joint);
                ++i;
            }
        } else {
            this.jointContacts.remove(joint);
        }
    }

    public final int getNumJoints() {
        return this.joints.size() + this.jointContacts.size();
    }

    public final Joint getFirstJoint() {
        if (!this.joints.isEmpty()) {
            return this.joints.getHead();
        }
        return this.jointContacts.getHead();
    }

    public final Joint getNextJoint(Joint last) {
        Joint next = last.getNext();
        if (next == null && !(last instanceof JointContact)) {
            return this.jointContacts.getHead();
        }
        return next;
    }

    public void removeJointContacts() {
        Joint joint = this.jointContacts.getHead();
        while (joint != null) {
            ((JointContact)joint).removeJointReferencesFromAttachedBodies();
            joint = joint.getNext();
        }
        this.jointContacts.clear();
    }

    public void addForce(WorldForce force) {
        force.setWorld(this);
        this.forces.add(force);
    }

    public void removeForce(WorldForce force) {
        force.setWorld(null);
        this.forces.remove(force);
    }

    public final int getNumForces() {
        return this.forces.size();
    }

    public final Iterator<WorldForce> getForces() {
        return this.forces.iterator();
    }

    public final void setStepFunction(int stepFunction) {
        this.stepFunction = stepFunction;
    }

    public final int getStepFunction() {
        return this.stepFunction;
    }

    public final void setUserData(Object data) {
        this.userData = data;
    }

    public final Object getUserData() {
        return this.userData;
    }

    public final void setGlobalERP(float value) {
        this.global_erp = value;
    }

    public final float getGlobalERP() {
        return this.global_erp;
    }

    public final void setGlobalCFM(float value) {
        this.global_cfm = value;
    }

    public final float getGlobalCFM() {
        return this.global_cfm;
    }

    public final void setContactParameters(ContactParameters params) {
        this.contactParams = params;
    }

    public final ContactParameters getContactParameters() {
        return this.contactParams;
    }

    public void step(float stepsize) {
        switch (this.stepFunction) {
            case 0: {
                this.stepEuler(stepsize);
                break;
            }
            case 1: {
                this.stepRungeKutter(stepsize);
                break;
            }
            case 2: {
                this.stepSimple(stepsize);
                break;
            }
            case 4: {
                this.stepAccurateSimple(stepsize);
                break;
            }
            case 3: {
                this.stepQuick(stepsize);
                break;
            }
            default: {
                assert (false) : "invalid stepper function selected";
                break;
            }
        }
    }

    public void stepEuler(float stepsize) {
        assert (stepsize > 0.0f) : "stepsize must be > 0";
        int i = 0;
        while (i < this.forces.size()) {
            this.forces.get(i).prepare(this.time);
            ++i;
        }
        StepUtils.dxProcessIslands(this, this.time, this.time + stepsize, EulerStepper.getInstance());
        this.time += stepsize;
        i = 0;
        while (i < this.stepListeners.size()) {
            this.stepListeners.get(i).notifyStep(this, this.time);
            ++i;
        }
    }

    public void stepRungeKutter(float stepsize) {
        assert (stepsize > 0.0f) : "stepsize must be > 0";
        RungeKuttaOrder4Stepper.getInstance().step(this, this.time, this.time + stepsize);
        this.time += stepsize;
        int i = 0;
        while (i < this.stepListeners.size()) {
            this.stepListeners.get(i).notifyStep(this, this.time);
            ++i;
        }
    }

    public void stepSimple(float stepsize) {
        SimpleStepper.INSTANCE.step(this, this.time, this.time + stepsize);
        this.time += stepsize;
        int i = 0;
        while (i < this.stepListeners.size()) {
            this.stepListeners.get(i).notifyStep(this, this.time);
            ++i;
        }
    }

    public void stepAccurateSimple(float stepsize) {
        AccurateSimpleStepper.getInstance().step(this, this.time, this.time + stepsize);
        this.time += stepsize;
        int i = 0;
        while (i < this.stepListeners.size()) {
            this.stepListeners.get(i).notifyStep(this, this.time);
            ++i;
        }
    }

    public void stepQuick(float stepsize) {
        assert (stepsize > 0.0f) : "stepsize must be > 0";
        StepUtils.dxProcessIslands(this, this.time, this.time + stepsize, QuickStepper.getInstance());
        this.time += stepsize;
        int i = 0;
        while (i < this.stepListeners.size()) {
            this.stepListeners.get(i).notifyStep(this, this.time);
            ++i;
        }
    }

    @Override
    public World cloneState(ClonedReferences clones) {
        World clone = new World();
        clones.addClone(this, clone);
        clone.global_cfm = this.global_cfm;
        clone.global_erp = this.global_erp;
        clone.contactParams = (ContactParameters)clones.getClone(this.contactParams);
        Body body = this.getFirstBody();
        while (body != null) {
            clone.bodies.add((Body)clones.getClone(body));
            body = body.getNext();
        }
        Joint joint = this.getFirstJoint();
        while (body != null) {
            clone.joints.add((Joint)clones.getClone(joint));
            joint = this.getNextJoint(joint);
        }
        int i = 0;
        while (i < this.forces.size()) {
            clone.forces.add((WorldForce)clones.getClone(this.forces.get(i)));
            ++i;
        }
        i = 0;
        while (i < this.bodyListeners.size()) {
            if (this.bodyListeners.get(i) instanceof SimState) {
                clone.bodyListeners.add((WorldBodyListener)((Object)clones.getClone((SimState)((Object)this.bodyListeners.get(i)))));
            }
            ++i;
        }
        i = 0;
        while (i < this.jointListeners.size()) {
            if (this.jointListeners.get(i) instanceof SimState) {
                clone.jointListeners.add((WorldJointListener)((Object)clones.getClone((SimState)((Object)this.jointListeners.get(i)))));
            }
            ++i;
        }
        i = 0;
        while (i < this.stepListeners.size()) {
            if (this.stepListeners.get(i) instanceof SimState) {
                clone.stepListeners.add((WorldStepListener)((Object)clones.getClone((SimState)((Object)this.stepListeners.get(i)))));
            }
            ++i;
        }
        if (this.userData instanceof SimState) {
            clone.userData = clones.getClone((SimState)this.userData);
        }
        return clone;
    }

    public final void addBodyListener(WorldBodyListener listener) {
        this.bodyListeners.add(listener);
    }

    public final void removeBodyListener(WorldBodyListener listener) {
        this.bodyListeners.remove(listener);
    }

    public final void addJointListener(WorldJointListener listener) {
        this.jointListeners.add(listener);
    }

    public final void removeJointListener(WorldJointListener listener) {
        this.jointListeners.remove(listener);
    }

    public final void addStepListener(WorldStepListener listener, boolean avoidDuplicates) {
        boolean doAdd = true;
        if (avoidDuplicates) {
            boolean bl = doAdd = !this.stepListeners.contains(listener);
        }
        if (doAdd) {
            this.stepListeners.add(listener);
        }
    }

    public final void addStepListener(WorldStepListener listener) {
        this.addStepListener(listener, false);
    }

    public final void removeStepListener(WorldStepListener listener) {
        this.stepListeners.remove(listener);
    }

    public final void addWorldListener(WorldListener listener) {
        this.bodyListeners.add(listener);
        this.jointListeners.add(listener);
        this.stepListeners.add(listener);
    }

    public final void removeWorldListener(WorldListener listener) {
        this.bodyListeners.remove(listener);
        this.jointListeners.remove(listener);
        this.stepListeners.add(listener);
    }
}

