/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.SimState;

public class SurfaceParameters
implements SimState {
    private static final long serialVersionUID = -5292017857810209050L;
    public static final int CONTACT_MU2 = 1;
    public static final int CONTACT_FDIR1 = 2;
    public static final int CONTACT_BOUNCE = 4;
    public static final int CONTACT_SOFT_ERP = 8;
    public static final int CONTACT_SOFT_CFM = 16;
    public static final int CONTACT_MOTION1 = 32;
    public static final int CONTACT_MOTION2 = 64;
    public static final int CONTACT_SLIP1 = 128;
    public static final int CONTACT_SLIP2 = 256;
    public static final int CONTACT_APPROX0 = 0;
    public static final int CONTACT_APPROX1_1 = 4096;
    public static final int CONTACT_APPROX1_2 = 8192;
    public static final int CONTACT_APPROX1 = 12288;
    private int mode;
    private float mu;
    private float mu2;
    private float bounce;
    private float bounce_vel;
    private float soft_erp;
    private float soft_cfm;
    private float motion1;
    private float motion2;
    private float slip1;
    private float slip2;

    public SurfaceParameters() {
    }

    public SurfaceParameters(float mu) {
        this.mu = mu;
    }

    public SurfaceParameters(SurfaceParameters s) {
        this.set(s);
    }

    public void set(SurfaceParameters s) {
        this.mode = s.mode;
        this.mu = s.mu;
        this.mu2 = s.mu2;
        this.bounce = s.bounce;
        this.bounce_vel = s.bounce_vel;
        this.soft_erp = s.soft_erp;
        this.soft_cfm = s.soft_cfm;
        this.motion1 = s.motion1;
        this.motion2 = s.motion2;
        this.slip1 = s.slip1;
        this.slip2 = s.slip2;
    }

    public final void setMode(int mode) {
        this.mode = mode;
    }

    public final void addModeFlag(int mode) {
        this.mode |= mode;
    }

    public final void removeModeFlag(int mode) {
        this.mode &= ~mode;
    }

    public final int getMode() {
        return this.mode;
    }

    public final boolean isModeFlagSet(int mode) {
        return (this.mode & mode) != 0;
    }

    public final void setMu(float mu) {
        this.mu = mu;
    }

    public final float getMu() {
        return this.mu;
    }

    public final void setMu2(float mu2) {
        this.mu2 = mu2;
    }

    public final float getMu2() {
        return this.mu2;
    }

    public final void setBounce(float bounce) {
        this.bounce = bounce;
    }

    public final float getBounce() {
        return this.bounce;
    }

    public final void setBounceVel(float bounceVel) {
        this.bounce_vel = bounceVel;
    }

    public final float getBounceVel() {
        return this.bounce_vel;
    }

    public final void setSoftERP(float softERP) {
        this.soft_erp = softERP;
    }

    public final float getSoftERP() {
        return this.soft_erp;
    }

    public final void setSoftCFM(float softCFM) {
        this.soft_cfm = softCFM;
    }

    public final float getSoftCFM() {
        return this.soft_cfm;
    }

    public final void setMotion1(float motion1) {
        this.motion1 = motion1;
    }

    public final float getMotion1() {
        return this.motion1;
    }

    public final void setMotion2(float motion2) {
        this.motion2 = motion2;
    }

    public final float getMotion2() {
        return this.motion2;
    }

    public final void setSlip1(float slip1) {
        this.slip1 = slip1;
    }

    public final float getSlip1() {
        return this.slip1;
    }

    public final void setSlip2(float slip2) {
        this.slip2 = slip2;
    }

    public final float getSlip2() {
        return this.slip2;
    }

    public SurfaceParameters cloneState(ClonedReferences util) {
        SurfaceParameters clone = new SurfaceParameters();
        util.addClone(this, clone);
        clone.mode = this.mode;
        clone.mu = this.mu;
        clone.mu2 = this.mu2;
        clone.bounce = this.bounce;
        clone.bounce_vel = this.bounce_vel;
        clone.soft_erp = this.soft_erp;
        clone.soft_cfm = this.soft_cfm;
        clone.motion1 = this.motion1;
        clone.motion2 = this.motion2;
        clone.slip1 = this.slip1;
        clone.slip2 = this.slip2;
        return clone;
    }
}

