/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import java.util.Arrays;
import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.collision.collider.Colliders;
import net.java.dev.joode.geom.Box;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.Vector3;

public class BoxBoxCollider
extends Collider {
    private static Vector3 normal = new Vector3();
    public static final BoxBoxCollider INSTANCE = new BoxBoxCollider();
    public static final float fudge_factor = 1.05f;

    public int collide(Geom o1, Geom o2, ContactGeom[] contact, int contactIndex, int skip) {
        Box box1 = (Box)o1;
        Box box2 = (Box)o2;
        Vector3 box1Pos = box1.getPosition();
        Matrix3 box1Rot = box1.getRotation();
        Vector3 box2Pos = box2.getPosition();
        Matrix3 box2Rot = box2.getRotation();
        normal.set(0.0f, 0.0f, 0.0f);
        int num = BoxBoxCollider.collideBoxes(box1Pos, box1Rot, box1.getSide(), box2Pos, box2Rot, box2.getSide(), normal, contact, contactIndex);
        normal.scale(-1.0f);
        int i = 0;
        while (i < num) {
            contact[contactIndex + i].setNormal(normal);
            contact[contactIndex + i].setGeom1(o1);
            contact[contactIndex + i].setGeom2(o2);
            ++i;
        }
        return num;
    }

    public static int collideBoxes(Vector3 p1, Matrix3 R1, Vector3 side1, Vector3 p2, Matrix3 R2, Vector3 side2, Vector3 normal, ContactGeom[] contact, int contactIndex) {
        int code2;
        int code1;
        int i;
        int a2;
        int lanr;
        int a1;
        Vector3 Sb;
        Vector3 Sa;
        Vector3 pb;
        Vector3 pa;
        Vector3 p = new Vector3(p2);
        p.sub(p1);
        Vector3 pp = new Vector3();
        MathUtils.dMULTIPLY1_331(pp, R1, p);
        Vector3 A = new Vector3(side1);
        A.scale(0.5f);
        Vector3 B = new Vector3(side2);
        B.scale(0.5f);
        Real c11 = R1.getColumn(0);
        Real c12 = R1.getColumn(1);
        Real c13 = R1.getColumn(2);
        Real c21 = R2.getColumn(0);
        Real c22 = R2.getColumn(1);
        Real c23 = R2.getColumn(2);
        float R11 = c11.dot(c21);
        float R12 = c11.dot(c22);
        float R13 = c11.dot(c23);
        float R21 = c12.dot(c21);
        float R22 = c12.dot(c22);
        float R23 = c12.dot(c23);
        float R31 = c13.dot(c21);
        float R32 = c13.dot(c22);
        float R33 = c13.dot(c23);
        float Q11 = Math.abs(R11);
        float Q12 = Math.abs(R12);
        float Q13 = Math.abs(R13);
        float Q21 = Math.abs(R21);
        float Q22 = Math.abs(R22);
        float Q23 = Math.abs(R23);
        float Q31 = Math.abs(R31);
        float Q32 = Math.abs(R32);
        float Q33 = Math.abs(R33);
        Penetration struct = new Penetration();
        if (BoxBoxCollider.checkAxisPenetration(pp.getX(), A.getX() + B.getX() * Q11 + B.getY() * Q12 + B.getZ() * Q13, R1.m[0], R1.m[4], R1.m[8], 1, struct)) {
            return 0;
        }
        if (BoxBoxCollider.checkAxisPenetration(pp.getY(), A.m[1] + B.getX() * Q21 + B.getY() * Q22 + B.getZ() * Q23, R1.m[1], R1.m[5], R1.m[9], 2, struct)) {
            return 0;
        }
        if (BoxBoxCollider.checkAxisPenetration(pp.getZ(), A.getZ() + B.getX() * Q31 + B.getY() * Q32 + B.getZ() * Q33, R1.m[2], R1.m[6], R1.m[10], 3, struct)) {
            return 0;
        }
        if (BoxBoxCollider.checkAxisPenetration(p.dot(R2.getColumn(0)), A.getX() * Q11 + A.getY() * Q21 + A.getZ() * Q31 + B.getX(), R2.m[0], R2.m[4], R2.m[8], 4, struct)) {
            return 0;
        }
        if (BoxBoxCollider.checkAxisPenetration(p.dot(R2.getColumn(1)), A.getX() * Q12 + A.getY() * Q22 + A.getZ() * Q32 + B.getY(), R2.m[1], R2.m[5], R2.m[9], 5, struct)) {
            return 0;
        }
        if (BoxBoxCollider.checkAxisPenetration(p.dot(R2.getColumn(2)), A.getX() * Q13 + A.getY() * Q23 + A.getZ() * Q33 + B.getZ(), R2.m[2], R2.m[6], R2.m[10], 6, struct)) {
            return 0;
        }
        if (BoxBoxCollider.checkCrossProductAxisPenetration(pp.m[2] * R21 - pp.m[1] * R31, A.m[1] * Q31 + A.m[2] * Q21 + B.m[1] * Q13 + B.m[2] * Q12, 0.0f, -R31, R21, 7, struct)) {
            return 0;
        }
        if (BoxBoxCollider.checkCrossProductAxisPenetration(pp.m[2] * R22 - pp.m[1] * R32, A.m[1] * Q32 + A.m[2] * Q22 + B.m[0] * Q13 + B.m[2] * Q11, 0.0f, -R32, R22, 8, struct)) {
            return 0;
        }
        if (BoxBoxCollider.checkCrossProductAxisPenetration(pp.m[2] * R23 - pp.m[1] * R33, A.m[1] * Q33 + A.m[2] * Q23 + B.m[0] * Q12 + B.m[1] * Q11, 0.0f, -R33, R23, 9, struct)) {
            return 0;
        }
        if (BoxBoxCollider.checkCrossProductAxisPenetration(pp.m[0] * R31 - pp.m[2] * R11, A.m[0] * Q31 + A.m[2] * Q11 + B.m[1] * Q23 + B.m[2] * Q22, R31, 0.0f, -R11, 10, struct)) {
            return 0;
        }
        if (BoxBoxCollider.checkCrossProductAxisPenetration(pp.m[0] * R32 - pp.m[2] * R12, A.m[0] * Q32 + A.m[2] * Q12 + B.m[0] * Q23 + B.m[2] * Q21, R32, 0.0f, -R12, 11, struct)) {
            return 0;
        }
        if (BoxBoxCollider.checkCrossProductAxisPenetration(pp.m[0] * R33 - pp.m[2] * R13, A.m[0] * Q33 + A.m[2] * Q13 + B.m[0] * Q22 + B.m[1] * Q21, R33, 0.0f, -R13, 12, struct)) {
            return 0;
        }
        if (BoxBoxCollider.checkCrossProductAxisPenetration(pp.m[1] * R11 - pp.m[0] * R21, A.m[0] * Q21 + A.m[1] * Q11 + B.m[1] * Q33 + B.m[2] * Q32, -R21, R11, 0.0f, 13, struct)) {
            return 0;
        }
        if (BoxBoxCollider.checkCrossProductAxisPenetration(pp.m[1] * R12 - pp.m[0] * R22, A.m[0] * Q22 + A.m[1] * Q12 + B.m[0] * Q33 + B.m[2] * Q31, -R22, R12, 0.0f, 14, struct)) {
            return 0;
        }
        if (BoxBoxCollider.checkCrossProductAxisPenetration(pp.m[1] * R13 - pp.m[0] * R23, A.m[0] * Q23 + A.m[1] * Q13 + B.m[0] * Q32 + B.m[1] * Q31, -R23, R13, 0.0f, 15, struct)) {
            return 0;
        }
        if (struct.code == 0) {
            return 0;
        }
        if (struct.normalR != null) {
            normal.set(struct.normalR);
        } else {
            R1.mulInc(struct.normalC, normal);
        }
        if (struct.invert_normal) {
            normal.scale(-1.0f);
        }
        float depth = -struct.s;
        if (struct.code > 6) {
            int i2;
            int sign;
            Vector3 pa2 = new Vector3(p1);
            int j = 0;
            while (j < 3) {
                sign = normal.dot(R1.getColumn(j)) > 0.0f ? 1 : -1;
                i2 = 0;
                while (i2 < 3) {
                    int n = i2;
                    pa2.m[n] = pa2.m[n] + (float)sign * A.m[j] * R1.m[i2 * 4 + j];
                    ++i2;
                }
                ++j;
            }
            Vector3 pb2 = new Vector3(p2);
            j = 0;
            while (j < 3) {
                sign = normal.dot(R2.getColumn(j)) > 0.0f ? -1 : 1;
                i2 = 0;
                while (i2 < 3) {
                    int n = i2;
                    pb2.m[n] = pb2.m[n] + (float)sign * B.m[j] * R2.m[i2 * 4 + j];
                    ++i2;
                }
                ++j;
            }
            Vector3 ua = new Vector3();
            Vector3 ub = new Vector3();
            i2 = 0;
            while (i2 < 3) {
                ua.m[i2] = R1.m[(struct.code - 7) / 3 + i2 * 4];
                ++i2;
            }
            i2 = 0;
            while (i2 < 3) {
                ub.m[i2] = R2.m[(struct.code - 7) % 3 + i2 * 4];
                ++i2;
            }
            float[] alpha_beta = Colliders.lineClosestApproach(pa2, ua, pb2, ub);
            i2 = 0;
            while (i2 < 3) {
                int n = i2;
                pa2.m[n] = pa2.m[n] + ua.m[i2] * alpha_beta[0];
                ++i2;
            }
            i2 = 0;
            while (i2 < 3) {
                int n = i2;
                pb2.m[n] = pb2.m[n] + ub.m[i2] * alpha_beta[1];
                ++i2;
            }
            i2 = 0;
            while (i2 < 3) {
                contact[contactIndex].getPosition().m[i2] = 0.5f * (pa2.m[i2] + pb2.m[i2]);
                ++i2;
            }
            contact[contactIndex].setDepth(depth);
            return 1;
        }
        Matrix3 Ra = new Matrix3();
        Matrix3 Rb = new Matrix3();
        if (struct.code <= 3) {
            Ra.set(R1);
            Rb.set(R2);
            pa = new Vector3(p1);
            pb = new Vector3(p2);
            Sa = new Vector3(A);
            Sb = new Vector3(B);
        } else {
            Ra.set(R2);
            Rb.set(R1);
            pa = new Vector3(p2);
            pb = new Vector3(p1);
            Sa = new Vector3(B);
            Sb = new Vector3(A);
        }
        Vector3 normal2 = new Vector3(normal);
        if (struct.code > 3) {
            normal2.scale(-1.0f);
        }
        Vector3 nr = new Vector3();
        MathUtils.dMULTIPLY1_331(nr, Rb, normal2);
        Vector3 anr = new Vector3();
        anr.m[0] = Math.abs(nr.m[0]);
        anr.m[1] = Math.abs(nr.m[1]);
        anr.m[2] = Math.abs(nr.m[2]);
        if (anr.m[1] > anr.m[0]) {
            if (anr.m[1] > anr.m[2]) {
                a1 = 0;
                lanr = 1;
                a2 = 2;
            } else {
                a1 = 0;
                a2 = 1;
                lanr = 2;
            }
        } else if (anr.m[0] > anr.m[2]) {
            lanr = 0;
            a1 = 1;
            a2 = 2;
        } else {
            a1 = 0;
            a2 = 1;
            lanr = 2;
        }
        Vector3 center = new Vector3();
        if (nr.m[lanr] < 0.0f) {
            i = 0;
            while (i < 3) {
                center.m[i] = pb.m[i] - pa.m[i] + Sb.m[lanr] * Rb.m[i * 4 + lanr];
                ++i;
            }
        } else {
            i = 0;
            while (i < 3) {
                center.m[i] = pb.m[i] - pa.m[i] - Sb.m[lanr] * Rb.m[i * 4 + lanr];
                ++i;
            }
        }
        int codeN = struct.code <= 3 ? struct.code - 1 : struct.code - 4;
        if (codeN == 0) {
            code1 = 1;
            code2 = 2;
        } else if (codeN == 1) {
            code1 = 0;
            code2 = 2;
        } else {
            code1 = 0;
            code2 = 1;
        }
        float[] quad = new float[8];
        float c1 = center.dot(Ra.getColumn(code1));
        float c2 = center.dot(Ra.getColumn(code2));
        Real ca1 = Ra.getColumn(code1);
        Real ca2 = Ra.getColumn(code2);
        Real cb1 = Rb.getColumn(a1);
        Real cb2 = Rb.getColumn(a2);
        float m11 = ca1.dot(cb1);
        float m12 = ca1.dot(cb2);
        float m21 = ca2.dot(cb1);
        float m22 = ca2.dot(cb2);
        float k1 = m11 * Sb.m[a1];
        float k2 = m21 * Sb.m[a1];
        float k3 = m12 * Sb.m[a2];
        float k4 = m22 * Sb.m[a2];
        quad[0] = c1 - k1 - k3;
        quad[1] = c2 - k2 - k4;
        quad[2] = c1 - k1 + k3;
        quad[3] = c2 - k2 + k4;
        quad[4] = c1 + k1 + k3;
        quad[5] = c2 + k2 + k4;
        quad[6] = c1 + k1 - k3;
        quad[7] = c2 + k2 - k4;
        float[] rect = new float[]{Sa.m[code1], Sa.m[code2]};
        float[] ret = new float[16];
        Arrays.fill(ret, 0.0f);
        int n = Colliders.intersectRectQuad(rect, quad, ret);
        if (n < 1) {
            return 0;
        }
        Vector3[] point = new Vector3[8];
        float[] dep = new float[8];
        float det1 = 1.0f / (m11 * m22 - m12 * m21);
        m11 *= det1;
        m12 *= det1;
        m21 *= det1;
        m22 *= det1;
        int cnum = 0;
        int j = 0;
        while (j < n) {
            k1 = m22 * (ret[j * 2] - c1) - m12 * (ret[j * 2 + 1] - c2);
            k2 = -m21 * (ret[j * 2] - c1) + m11 * (ret[j * 2 + 1] - c2);
            point[j] = new Vector3();
            i = 0;
            while (i < 3) {
                point[cnum].m[i] = center.m[i] + k1 * Rb.m[i * 4 + a1] + k2 * Rb.m[i * 4 + a2];
                ++i;
            }
            dep[cnum] = Sa.m[codeN] - normal2.dot(point[cnum]);
            if (dep[cnum] >= 0.0f) {
                ret[cnum * 2] = ret[j * 2];
                ret[cnum * 2 + 1] = ret[j * 2 + 1];
                ++cnum;
            }
            ++j;
        }
        if (cnum < 1) {
            return 0;
        }
        int maxc = contact.length - contactIndex;
        if (maxc > cnum) {
            maxc = cnum;
        }
        if (maxc < 1) {
            maxc = 1;
        }
        if (cnum <= maxc) {
            j = 0;
            while (j < cnum) {
                ContactGeom con = contact[contactIndex + j];
                i = 0;
                while (i < 3) {
                    con.getPosition().m[i] = point[j].m[i] + pa.m[i];
                    ++i;
                }
                con.setDepth(dep[j]);
                ++j;
            }
        } else {
            int i1 = 0;
            float maxdepth = dep[0];
            i = 1;
            while (i < cnum) {
                if (dep[i] > maxdepth) {
                    maxdepth = dep[i];
                    i1 = i;
                }
                ++i;
            }
            int[] iret = new int[8];
            Colliders.cullPoints(cnum, ret, maxc, i1, iret);
            j = 0;
            while (j < maxc) {
                ContactGeom con = contact[contactIndex + j];
                i = 0;
                while (i < 3) {
                    con.getPosition().m[i] = point[iret[j]].m[i] + pa.m[i];
                    ++i;
                }
                con.setDepth(dep[iret[j]]);
                ++j;
            }
            cnum = maxc;
        }
        return cnum;
    }

    private static boolean checkAxisPenetration(float projectedCenterDistance, float projectedSumOfRadii, float n1, float n2, float n3, int cc, Penetration struct) {
        float s2 = Math.abs(projectedCenterDistance) - projectedSumOfRadii;
        if (s2 > 0.0f) {
            return true;
        }
        if (s2 > struct.s) {
            struct.s = s2;
            struct.normalR = new Vector3(n1, n2, n3);
            struct.invert_normal = projectedCenterDistance < 0.0f;
            struct.code = cc;
        }
        return false;
    }

    private static boolean checkCrossProductAxisPenetration(float expR1, float expr2, float n1, float n2, float n3, int cc, Penetration struct) {
        float s2 = Math.abs(expR1) - expr2;
        if (s2 > 0.0f) {
            return true;
        }
        float l = (float)Math.sqrt(n1 * n1 + n2 * n2 + n3 * n3);
        if (l > 0.0f && (s2 /= l) * 1.05f > struct.s) {
            struct.s = s2;
            struct.normalR = null;
            struct.normalC = new Vector3(n1 / l, n2 / l, n3 / l);
            struct.invert_normal = expR1 < 0.0f;
            struct.code = cc;
        }
        return false;
    }

    private static class Penetration {
        float s = Float.NEGATIVE_INFINITY;
        Vector3 normalR;
        Vector3 normalC;
        boolean invert_normal = false;
        int code = 0;

        private Penetration() {
        }
    }
}

