/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.collision.collider;

import net.java.dev.joode.collision.ContactGeom;
import net.java.dev.joode.collision.collider.Collider;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.geom.Ray;
import net.java.dev.joode.geom.Sphere;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;

public class RaySphereCollider
extends Collider {
    public static final RaySphereCollider INSTANCE = new RaySphereCollider();

    public int collide(Geom o1, Geom o2, ContactGeom[] contact, int contactIndex, int skip) {
        Ray ray = (Ray)o1;
        Sphere sphere = (Sphere)o2;
        contact[contactIndex].setGeom1(ray);
        contact[contactIndex].setGeom2(sphere);
        return RaySphereCollider.ray_sphere_helper(ray, sphere.getPosition(), sphere.getRadius(), contact, contactIndex, false);
    }

    public static int ray_sphere_helper(Ray ray, Vector3 sphere_pos, float radius, ContactGeom[] contact, int contactIndex, boolean mode) {
        float alpha;
        Vector3 q = new Vector3(ray.getPosition());
        q.sub(sphere_pos);
        float B = q.dot(ray.getRotation().getColumn(2));
        float C = q.lengthSquared() - radius * radius;
        float k = B * B - C;
        if (k < 0.0f) {
            return 0;
        }
        k = (float)Math.sqrt(k);
        if (mode && C >= 0.0f ? (alpha = -B + k) < 0.0f : (alpha = -B - k) < 0.0f && (alpha = -B + k) < 0.0f) {
            return 0;
        }
        if (alpha > ray.getLength()) {
            return 0;
        }
        Vector3 rayPos = ray.getPosition();
        Matrix3 rayRot = ray.getRotation();
        contact[contactIndex].getPosition().m[0] = rayPos.getX() + alpha * rayRot.m[2];
        contact[contactIndex].getPosition().m[1] = rayPos.getY() + alpha * rayRot.m[6];
        contact[contactIndex].getPosition().m[2] = rayPos.getZ() + alpha * rayRot.m[10];
        float nsign = C < 0.0f || mode ? -1 : 1;
        contact[contactIndex].getNormal().setX(nsign * (contact[contactIndex].getPosition().getX() - sphere_pos.getX()));
        contact[contactIndex].getNormal().setY(nsign * (contact[contactIndex].getPosition().getY() - sphere_pos.getY()));
        contact[contactIndex].getNormal().setZ(nsign * (contact[contactIndex].getPosition().getZ() - sphere_pos.getZ()));
        contact[contactIndex].getNormal().normalize();
        contact[contactIndex].setDepth(alpha);
        return 1;
    }
}

