/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.force;

import net.java.dev.joode.Body;
import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.World;
import net.java.dev.joode.force.Gravity;
import net.java.dev.joode.force.WorldForce;
import net.java.dev.joode.util.Vector3;
import org.openmali.FastMath;

public class UniversalGravity
extends WorldForce
implements Gravity {
    private static final long serialVersionUID = 715954045182080955L;
    public static final float GRAVITATIONAL_CONSTANT = 6.6742E-11f;
    private final Body body;

    public UniversalGravity(World world, Body body) {
        super(world);
        this.body = body;
    }

    public final Body getBody() {
        return this.body;
    }

    public void prepare(float t) {
    }

    public void applyForce(Body body, float t, Vector3 faccPassback, Vector3 taccPassback) {
        if (this.body == body) {
            return;
        }
        if (!body.getFlag(64)) {
            return;
        }
        Vector3 thisBodyPos = this.body.getPosition();
        Vector3 bodyPos = body.getPosition();
        float x = thisBodyPos.getX() - bodyPos.getX();
        float y = thisBodyPos.getY() - bodyPos.getY();
        float z = thisBodyPos.getZ() - bodyPos.getZ();
        float distSquared = x * x + y * y + z * z;
        float F = 6.6742E-11f * this.body.getMass().getMass() * body.getMass().getMass() / distSquared;
        float dist = FastMath.sqrt(distSquared);
        faccPassback.m[0] = faccPassback.m[0] + x / dist * F;
        faccPassback.m[1] = faccPassback.m[1] + y / dist * F;
        faccPassback.m[2] = faccPassback.m[2] + z / dist * F;
    }

    public UniversalGravity cloneState(ClonedReferences util) {
        UniversalGravity clone = new UniversalGravity((World)util.getClone(this.getWorld()), (Body)util.getClone(this.body));
        util.addClone(this, clone);
        return clone;
    }
}

