/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.geom;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;
import org.openmali.FastMath;

public class Capsule
extends Geom {
    private static final long serialVersionUID = -6993659653939907339L;
    private float radius;
    private float lz;

    public Capsule(Space space, float radius, float length) {
        super(space, 2, true);
        assert (radius > 0.0f) : "radius must be greater than zero";
        assert (length > 0.0f) : "length must be greater than zero";
        this.radius = radius;
        this.lz = length;
        if (space != null) {
            space.add(this);
        }
    }

    private Capsule() {
        super(2, true);
    }

    public final float getRadius() {
        return this.radius;
    }

    public final void setRadius(float radius) {
        this.radius = radius;
        Space.onGeomMoved(this);
    }

    public final float getLength() {
        return this.lz;
    }

    public final void setLength(float length) {
        this.lz = length;
        Space.onGeomMoved(this);
    }

    public void computeAABB() {
        Vector3 pos = this.getPosition();
        Matrix3 rot = this.getRotation();
        float rx = rot.get(2, 0);
        float ry = rot.get(2, 1);
        float rz = rot.get(2, 2);
        float lz2 = this.lz * 0.5f;
        float xrange = Math.abs(rx * lz2) + this.radius;
        float yrange = Math.abs(ry * lz2) + this.radius;
        float zrange = Math.abs(rz * lz2) + this.radius;
        this.getAABB().set(pos.getX() - xrange, pos.getX() + xrange, pos.getY() - yrange, pos.getY() + yrange, pos.getZ() - zrange, pos.getZ() + zrange);
    }

    public float pointDepth(float x, float y, float z) {
        float lz2;
        Vector3 pos = this.getPosition();
        Matrix3 rot = this.getRotation();
        Vector3 a = new Vector3(x - pos.getX(), y - pos.getY(), z - pos.getZ());
        float beta = a.dot(rot.getColumn(2));
        if (beta < -(lz2 = this.lz * 0.5f)) {
            beta = -lz2;
        } else if (beta > lz2) {
            beta = lz2;
        }
        a.setX(x - pos.getX() + beta * rot.get(2, 0));
        a.setY(y - pos.getY() + beta * rot.get(2, 1));
        a.setZ(z - pos.getZ() + beta * rot.get(2, 2));
        return this.radius - FastMath.sqrt(a.getX() * a.getX() + a.getY() * a.getY() + a.getZ() * a.getZ());
    }

    public Capsule cloneState(ClonedReferences util) {
        Capsule clone = new Capsule();
        this.clonePartialGeom(clone, util);
        clone.radius = this.radius;
        clone.lz = this.lz;
        return clone;
    }
}

