/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.geom;

import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.Vector3;
import org.openmali.FastMath;

public class Circle
extends Geom {
    private static final long serialVersionUID = -4429379386426443950L;
    private float radius;

    public Circle(Space space, float radius) {
        super(space, 9, true);
        assert (radius > 0.0f) : "radius of a circle must be greater than zero";
        this.radius = radius;
        if (space != null) {
            space.add(this);
        }
    }

    private Circle() {
        super(9, true);
    }

    public void computeAABB() {
        Vector3 pos = this.getPosition();
        this.getAABB().set(pos.getX() - this.radius, pos.getX() + this.radius, pos.getY() - this.radius, pos.getY() + this.radius, -3.4028235E38f, Float.MAX_VALUE);
    }

    public float pointDepth(float x, float y, float z) {
        float xDist = x - this.getPosition().getX();
        float yDist = y - this.getPosition().getY();
        return this.radius - FastMath.sqrt(xDist * xDist + yDist * yDist);
    }

    public final float getRadius() {
        return this.radius;
    }

    public final void setRadius(float radius) {
        this.radius = radius;
    }

    public Circle cloneState(ClonedReferences util) {
        Circle clone = new Circle();
        this.clonePartialGeom(clone, util);
        clone.radius = this.radius;
        return clone;
    }
}

