/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.geom;

import java.util.HashMap;
import java.util.Iterator;
import net.java.dev.joode.Body;
import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.SimState;
import net.java.dev.joode.space.NearCallback;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.AABB3f;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.PosRot;
import net.java.dev.joode.util.Quaternion;
import net.java.dev.joode.util.Vector3;
import org.jagatoo.datatypes.DoublyChainable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Geom
implements DoublyChainable<Geom>,
SimState {
    public static int GEOM_DIRTY = 1;
    public static int GEOM_AABB_BAD = 2;
    public static int GEOM_PLACEABLE = 4;
    public static int GEOM_ENABLED = 8;
    public static int RAY_FIRSTCONTACT = 65536;
    public static int RAY_BACKFACECULL = 131072;
    public static int RAY_CLOSEST_HIT = 262144;
    public static final int GEOM_TYPE_SPHERE = 0;
    public static final int GEOM_TYPE_BOX = 1;
    public static final int GEOM_TYPE_CAPSULE = 2;
    public static final int GEOM_TYPE_CYLINDER = 3;
    public static final int GEOM_TYPE_PLANE = 4;
    public static final int GEOM_TYPE_RAY = 5;
    public static final int GEOM_TYPE_GEOM_TRANSFORM = 6;
    public static final int GEOM_TYPE_CONVEX = 7;
    public static final int GEOM_TYPE_TRIMESH = 8;
    public static final int GEOM_TYPE_CIRCLE = 9;
    public static final int GEOM_TYPE_RECTANGLE = 10;
    public static final int GEOM_TYPE_SIMPLE_SPACE = 11;
    public static final int GEOM_TYPE_HASH_SPACE = 12;
    public static final int GEOM_TYPE_OCTREE_SPACE = 13;
    public static final int GROM_TYPE_QUADTREE_SPACE = 14;
    public static final int GEOM_TYPE_COLLISION_LESS_SPACE = 15;
    public static final int FIRST_SPACE_CLASS = 11;
    public static final int LAST_SPACE_CLASS = 15;
    public static final int GEOM_TYPE_MAX_USER_TYPES = 4;
    public static final int GEOM_TYPE_FIRST_USER_TYPE = 16;
    public static final int GEOM_TYPE_LAST_USER_TYPE = 19;
    public static final int NUM_GEOM_TYPES = 20;
    public static final Quaternion tmpq = new Quaternion();
    private int type;
    private int gflags = 0;
    private Object userData = null;
    private final HashMap<String, Object> namedData = new HashMap();
    private Body body = null;
    private Geom previous = null;
    private Geom next = null;
    private Vector3 pos = new Vector3();
    private Vector3 lpos = new Vector3();
    private Matrix3 rot = new Matrix3();
    private final PosRot pr = new PosRot();
    private Space parentSpace = null;
    private final AABB3f aabb = new AABB3f();
    public long category_bits;
    public long collide_bits;
    private final boolean isPlaceable;

    protected Geom(int type, boolean isPlaceable) {
        this.type = type;
        this.isPlaceable = isPlaceable;
    }

    public Geom(Space space, int type, boolean isPlaceable) {
        this(type, isPlaceable);
        this.gflags = GEOM_DIRTY | GEOM_AABB_BAD | GEOM_ENABLED;
        if (isPlaceable) {
            this.gflags |= GEOM_PLACEABLE;
        }
        this.userData = null;
        this.body = null;
        if (isPlaceable) {
            this.pos = this.pr.getPosition();
            this.lpos = new Vector3(this.pr.getPosition());
            this.rot = this.pr.getRotation();
            this.pos.setZero();
            this.rot.setIdentity();
        } else {
            this.pos = null;
            this.lpos = new Vector3();
            this.rot = null;
        }
        this.parentSpace = null;
        this.category_bits = -1L;
        this.collide_bits = -1L;
    }

    public void destroy() {
        if (this.parentSpace != null) {
            this.parentSpace.remove(this);
        }
        this.bodyRemove();
    }

    public final int getType() {
        return this.type;
    }

    public final boolean isPlaceable() {
        return this.isPlaceable;
    }

    public final void setParentSpace(Space parentSpace) {
        this.parentSpace = parentSpace;
    }

    public final Space getParentSpace() {
        return this.parentSpace;
    }

    public final Body getBody() {
        return this.body;
    }

    @Override
    public void setPrevious(Geom o) {
        this.previous = o;
    }

    @Override
    public Geom getPrevious() {
        return this.previous;
    }

    @Override
    public void setNext(Geom o) {
        this.next = o;
    }

    @Override
    public Geom getNext() {
        return this.next;
    }

    public final AABB3f getAABB() {
        return this.aabb;
    }

    public abstract void computeAABB();

    public boolean testAABB(Geom other, AABB3f aabb) {
        return true;
    }

    public void recomputeAABB() {
        if ((this.gflags & GEOM_AABB_BAD) != 0) {
            this.computeAABB();
            this.gflags &= ~GEOM_AABB_BAD;
        }
    }

    public final Object getUserData() {
        return this.userData;
    }

    public final void setUserData(Object data) {
        this.userData = data;
    }

    public final Object getUserData(String key) {
        return this.namedData.get(key);
    }

    public final void setUserData(String key, Object data) {
        this.namedData.put(key, data);
    }

    public final void setBody(Body body) {
        if (body != null) {
            this.pos = body.getPosition();
            this.lpos = new Vector3(body.getPosition());
            this.rot = body.getRotation();
            Space.onGeomMoved(this);
            if (this.body != body) {
                this.bodyRemove();
                this.bodyAdd(body);
            }
        } else if (this.body != null) {
            this.pos = new Vector3(this.body.getPosition());
            this.lpos = new Vector3(this.body.getPosition());
            this.rot = new Matrix3();
            this.rot.set(this.body.getRotation());
            this.bodyRemove();
        }
        this.pr.setPositionReference(this.pos);
        this.pr.setRotationReference(this.rot);
    }

    public final void directSetPosition(Vector3 pos) {
        this.pos = pos;
    }

    public final void setPosition(float x, float y, float z) {
        if (!this.isPlaceable()) {
            return;
        }
        this.pos.set(x, y, z);
        this.lpos.set(x, y, z);
        Space.onGeomMoved(this);
    }

    public final void setPosition(Vector3 pos) {
        if (!this.isPlaceable()) {
            return;
        }
        this.pos.set(pos);
        this.lpos.set(pos);
        Space.onGeomMoved(this);
    }

    public final void position2LastPosition() {
        this.lpos.set(this.pos);
    }

    public final Vector3 getPosition() {
        return this.pos;
    }

    public final void directSetRotation(Matrix3 rot) {
        this.rot = rot;
    }

    public final void setRotation(Matrix3 rot) {
        if (!this.isPlaceable()) {
            return;
        }
        this.rot.set(rot);
        Space.onGeomMoved(this);
    }

    public final Matrix3 getRotation() {
        return this.rot;
    }

    public final void setQuaternion(float x, float y, float z, float w) {
        if (!this.isPlaceable()) {
            return;
        }
        tmpq.set(w, x, y, z);
        this.rot.set(tmpq);
        Space.onGeomMoved(this);
    }

    public final void setQuaternion(Quaternion q) {
        if (!this.isPlaceable()) {
            return;
        }
        this.rot.set(q);
        Space.onGeomMoved(this);
    }

    public final void setFlag(int flag, boolean b) {
        this.gflags = b ? (this.gflags |= flag) : (this.gflags &= ~flag);
    }

    public final boolean getFlag(int flag) {
        return (this.gflags & flag) == flag;
    }

    public final int getFlags() {
        return this.gflags;
    }

    public final void setEnabled(boolean enabled) {
        this.gflags = enabled ? (this.gflags |= GEOM_ENABLED) : (this.gflags &= ~GEOM_ENABLED);
    }

    public final boolean isEnabled() {
        return (this.gflags & GEOM_ENABLED) != 0;
    }

    private final void bodyAdd(Body body) {
        this.body = body;
        this.body.addGeom(this);
    }

    private final void bodyRemove() {
        if (this.body != null) {
            this.body.removeGeom(this);
        }
    }

    public final Geom clonePartialGeom(Geom partialClone, ClonedReferences util) {
        util.addClone(this, partialClone);
        partialClone.type = this.type;
        partialClone.gflags = this.gflags;
        if (this.userData instanceof SimState) {
            partialClone.userData = util.getClone((SimState)this.userData);
        }
        for (String label : this.namedData.keySet()) {
            Object data = this.namedData.get(label);
            if (!(data instanceof SimState)) continue;
            partialClone.namedData.put(label, util.getClone((SimState)data));
        }
        if (this.pos != null) {
            partialClone.pos.set(this.pos);
        }
        if (this.lpos != null) {
            partialClone.lpos.set(this.lpos);
        }
        if (this.rot != null) {
            partialClone.rot.set(this.rot);
        }
        partialClone.parentSpace = (Space)util.getClone(this.parentSpace);
        partialClone.aabb.set(this.aabb);
        partialClone.category_bits = this.category_bits;
        partialClone.collide_bits = this.collide_bits;
        if (this.body != null) {
            partialClone.setBody((Body)util.getClone(this.body));
        }
        return partialClone;
    }

    public static boolean collideAABBs(Geom g1, Geom g2, Object userData, NearCallback callback) {
        AABB3f bounds2;
        if (g1.getFlag(GEOM_AABB_BAD)) {
            g1.recomputeAABB();
        }
        if (g2.getFlag(GEOM_AABB_BAD)) {
            g2.recomputeAABB();
        }
        if (g1.getBody() == g2.getBody() && g1.getBody() != null) {
            return false;
        }
        if ((g1.category_bits & g2.collide_bits) == 0L && (g2.category_bits & g1.collide_bits) == 0L) {
            return false;
        }
        AABB3f bounds1 = g1.getAABB();
        if (!bounds1.intersects(bounds2 = g2.getAABB())) {
            return false;
        }
        if (!g1.testAABB(g2, bounds2)) {
            return false;
        }
        if (!g2.testAABB(g1, bounds1)) {
            return false;
        }
        callback.call(userData, g1, g2);
        return true;
    }

    public static void collide(Geom g1, Geom g2, Object userData, NearCallback callback) {
        Space s1 = g1 instanceof Space ? (Space)g1 : null;
        Space s2 = g2 instanceof Space ? (Space)g2 : null;
        if (s1 != null) {
            if (s2 != null) {
                if (s1 == s2) {
                    s1.collideAll(userData, callback);
                } else if (s1.getNumGeoms() < s2.getNumGeoms()) {
                    Iterator<Geom> i = s1.getGeomIterator();
                    while (i.hasNext()) {
                        s2.collide(userData, i.next(), false, callback);
                    }
                } else {
                    Iterator<Geom> i = s2.getGeomIterator();
                    while (i.hasNext()) {
                        s1.collide(userData, i.next(), true, callback);
                    }
                }
            } else {
                s1.collide(userData, g2, true, callback);
            }
        } else if (s2 != null) {
            s2.collide(userData, g1, false, callback);
        } else {
            callback.call(userData, g1, g2);
        }
    }

    public PosRot getPosRot() {
        return this.pr;
    }
}

