/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.geom;

import java.util.BitSet;
import java.util.Iterator;
import net.java.dev.joode.ClonedReferences;
import net.java.dev.joode.geom.Geom;
import net.java.dev.joode.space.Space;
import net.java.dev.joode.util.AABB3f;
import net.java.dev.joode.util.AABBSet;
import net.java.dev.joode.util.Vector3;
import net.java.dev.joode.util.Vector4;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriMesh
extends Geom {
    private static final long serialVersionUID = -5511859719587743706L;
    private int triangleCount;
    private Vector3[] vertices;
    private Vector3[] transformedVertices;
    private int[] indices;
    private AABBSet aabbSet;
    private BitSet planeCacheValidity;
    private TrianglePlanes[] planeCache;

    public TriMesh(Space space, boolean placeable, Vector3[] vertices, int[] indices) {
        super(space, 8, placeable);
        assert (indices.length % 3 == 0) : "indices.length not a multiple of 3";
        this.triangleCount = indices.length / 3;
        this.vertices = new Vector3[vertices.length];
        System.arraycopy(vertices, 0, this.vertices, 0, vertices.length);
        this.indices = new int[indices.length];
        System.arraycopy(indices, 0, this.indices, 0, indices.length);
        this.init();
        if (space != null) {
            space.add(this);
        }
    }

    private void init() {
        int i;
        if (this.getFlag(GEOM_PLACEABLE)) {
            this.transformedVertices = new Vector3[this.vertices.length];
            i = 0;
            while (i < this.transformedVertices.length) {
                this.transformedVertices[i] = new Vector3();
                ++i;
            }
        } else {
            this.transformedVertices = this.vertices;
        }
        this.aabbSet = new AABBSet(this.triangleCount);
        this.planeCacheValidity = new BitSet(this.triangleCount);
        this.planeCache = new TrianglePlanes[this.triangleCount];
        i = 0;
        while (i < this.triangleCount) {
            this.planeCache[i] = new TrianglePlanes();
            ++i;
        }
    }

    private TriMesh() {
        super(8, true);
    }

    public final Vector3[] getVertices() {
        return this.vertices;
    }

    public final int[] getIndices() {
        return this.indices;
    }

    public final int numTriangles() {
        return this.indices.length / 3;
    }

    public Iterable<Vector3[]> triangles() {
        return new TriangleIterable();
    }

    public final AABBSet getAABBSet() {
        return this.aabbSet;
    }

    @Override
    public void computeAABB() {
        int i;
        if (this.getFlag(GEOM_PLACEABLE)) {
            i = 0;
            while (i < this.vertices.length) {
                this.transformedVertices[i].set(this.getRotation().mul(this.vertices[i]).add(this.getPosition()));
                ++i;
            }
        }
        i = 0;
        int j = 0;
        while (i < this.triangleCount) {
            Vector3 v0 = this.transformedVertices[this.indices[j++]];
            Vector3 v1 = this.transformedVertices[this.indices[j++]];
            Vector3 v2 = this.transformedVertices[this.indices[j++]];
            this.aabbSet.compute(i, v0, v1, v2);
            ++i;
        }
        AABB3f globalBounds = this.aabbSet.getGlobalBounds();
        this.getAABB().set(globalBounds);
        this.planeCacheValidity.clear();
    }

    public void getTriangleData(int triangle, TriangleData data) {
        int i = triangle * 3;
        data.vertices[0] = this.transformedVertices[this.indices[i]];
        data.vertices[1] = this.transformedVertices[this.indices[i + 1]];
        data.vertices[2] = this.transformedVertices[this.indices[i + 2]];
        TrianglePlanes planes = this.planeCache[triangle];
        if (!this.planeCacheValidity.get(triangle)) {
            planes.setPlanes(data.vertices);
        }
        data.planes = planes;
    }

    private static void computeTrianglePlane(Vector3[] vertices, Vector4 plane) {
        Vector3 e1 = new Vector3(vertices[1]);
        Vector3 e2 = new Vector3(vertices[2]);
        e1.sub(vertices[0]);
        e2.sub(vertices[0]);
        e1.crossMe(e2);
        e1.normalize();
        plane.set(e1);
        e2.set(vertices[0]);
        plane.m[3] = e1.dot(e2);
    }

    private static void computeEdgePlane(Vector3 v1, Vector3 v2, Vector4 facePlane, Vector4 edgePlane) {
        Vector3 e1 = new Vector3(v1);
        Vector3 n = new Vector3(facePlane);
        e1.sub(v2);
        e1.crossMe(n);
        e1.normalize();
        edgePlane.set(e1);
        edgePlane.m[3] = v1.dot(e1);
    }

    public static float distanceFromPlane(Vector3 point, Vector4 plane) {
        return plane.dot(point) - plane.m[3];
    }

    public static boolean crossesPlane(Vector3[] vertices, Vector4 plane) {
        float d1;
        float d0 = TriMesh.distanceFromPlane(vertices[0], plane);
        if (d0 * (d1 = TriMesh.distanceFromPlane(vertices[1], plane)) <= 0.0f) {
            return true;
        }
        float d2 = TriMesh.distanceFromPlane(vertices[2], plane);
        return d0 * d2 <= 0.0f;
    }

    public static boolean crossesPlane(Vector3[] vertices, Vector4 plane, Vector3[] intersections) {
        float d0 = TriMesh.distanceFromPlane(vertices[0], plane);
        float d1 = TriMesh.distanceFromPlane(vertices[1], plane);
        float d2 = TriMesh.distanceFromPlane(vertices[2], plane);
        if (d0 * d1 <= 0.0f) {
            TriMesh.lineIntersectsPlane(vertices[0], vertices[1], plane, intersections[0]);
            if (d0 * d2 <= 0.0f) {
                TriMesh.lineIntersectsPlane(vertices[0], vertices[2], plane, intersections[1]);
            } else {
                TriMesh.lineIntersectsPlane(vertices[1], vertices[2], plane, intersections[1]);
            }
            return true;
        }
        if (d0 * d2 <= 0.0f) {
            TriMesh.lineIntersectsPlane(vertices[0], vertices[2], plane, intersections[0]);
            TriMesh.lineIntersectsPlane(vertices[1], vertices[2], plane, intersections[1]);
            return true;
        }
        return false;
    }

    public static boolean lineIntersectsPlane(Vector3 s1, Vector3 s2, Vector4 plane, Vector3 intersection) {
        float d1 = TriMesh.distanceFromPlane(s1, plane);
        Vector3 l = new Vector3(s2);
        l.sub(s1);
        float d2 = l.dot(plane);
        if ((double)Math.abs(d2) < 1.0E-6) {
            return false;
        }
        l.scale(-d1 / d2);
        intersection.set(l.add(s1));
        return true;
    }

    @Override
    public TriMesh cloneState(ClonedReferences util) {
        TriMesh clone = new TriMesh();
        this.clonePartialGeom(clone, util);
        clone.triangleCount = this.triangleCount;
        clone.vertices = this.vertices;
        clone.indices = this.indices;
        clone.init();
        return clone;
    }

    public static class TriangleData {
        public Vector3[] vertices = new Vector3[3];
        public TrianglePlanes planes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TriangleIterable
    implements Iterable<Vector3[]> {
        private TriangleIterable() {
        }

        @Override
        public Iterator<Vector3[]> iterator() {
            return new TriangleIterator();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TriangleIterator
    implements Iterator<Vector3[]> {
        private int index = 0;
        private Vector3[] v = new Vector3[3];

        private TriangleIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < TriMesh.this.indices.length;
        }

        @Override
        public Vector3[] next() {
            this.v[0] = TriMesh.this.vertices[TriMesh.this.indices[this.index++]];
            this.v[1] = TriMesh.this.vertices[TriMesh.this.indices[this.index++]];
            this.v[2] = TriMesh.this.vertices[TriMesh.this.indices[this.index++]];
            return this.v;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class TrianglePlanes {
        public Vector4 facePlane = new Vector4();
        public Vector4 edgePlane1 = new Vector4();
        public Vector4 edgePlane2 = new Vector4();
        public Vector4 edgePlane3 = new Vector4();

        public void setPlanes(Vector3[] vertices) {
            TriMesh.computeTrianglePlane(vertices, this.facePlane);
            TriMesh.computeEdgePlane(vertices[0], vertices[1], this.facePlane, this.edgePlane1);
            TriMesh.computeEdgePlane(vertices[1], vertices[2], this.facePlane, this.edgePlane2);
            TriMesh.computeEdgePlane(vertices[2], vertices[0], this.facePlane, this.edgePlane3);
        }
    }
}

