/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.stepper;

import net.java.dev.joode.Body;
import net.java.dev.joode.World;
import net.java.dev.joode.joint.Joint;
import net.java.dev.joode.stepper.StepperFunction;
import net.java.dev.joode.util.MathUtils;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Vector3;

public abstract class AbstractStepperFunction
implements StepperFunction {
    public static final boolean GYROSCOPIC = false;
    public static final Vector3 taccTmp = new Vector3();
    public static final Vector3 faccTmp = new Vector3();
    private static Matrix3 tmp = new Matrix3();
    private Vector3 avel = new Vector3();
    private Vector3 lvel = new Vector3();

    public void step(World world, Body[] body, int bcount, Joint[] joint, int jcount, float t_start, float t_end) {
        this.tagBodies(body, bcount);
        this.addExternalForces(body, bcount);
        Matrix3[] invI = this.getInverseInertiaTensors(body, bcount);
        Joint.Info1[] info = new Joint.Info1[jcount];
        jcount = this.getJointInfo(joint, jcount, info);
        int[] ofs = new int[jcount];
        int m = this.createRowOffsetArray(jcount, info, ofs);
        if (m > 0) {
            this.stepConstraints(m, world, body, bcount, joint, jcount, info, ofs, invI, t_start, t_end);
        }
        this.updateVelocity(body, bcount, invI, t_end - t_start);
        int i = 0;
        while (i < bcount) {
            body[i].step(t_end - t_start);
            ++i;
        }
        this.resetForces(body, bcount);
    }

    protected void tagBodies(Body[] bodies, int bcount) {
        int i = 0;
        while (i < bcount) {
            bodies[i].setTag(i);
            ++i;
        }
    }

    protected void addExternalForces(Body[] bodies, int bcount) {
        int i = 0;
        while (i < bcount) {
            bodies[i].getTotalForces(0.0f, faccTmp, taccTmp);
            bodies[i].getTACC().set(taccTmp);
            bodies[i].getFACC().set(faccTmp);
            ++i;
        }
    }

    protected Matrix3[] getInverseInertiaTensors(Body[] bodies, int bcount) {
        Matrix3[] invI = new Matrix3[bcount];
        tmp.setIdentity();
        Matrix3 I = new Matrix3();
        int i = 0;
        while (i < bcount) {
            bodies[i].getMass().invI.mulTranspose(bodies[i].getRotation(), tmp);
            invI[i] = new Matrix3();
            bodies[i].getRotation().mul(tmp, invI[i]);
            ++i;
        }
        return invI;
    }

    protected int getJointInfo(Joint[] joint, int jcount, Joint.Info1[] info) {
        int i = 0;
        int j = 0;
        while (j < jcount) {
            info[i] = new Joint.Info1();
            joint[j].getInfo1(info[i]);
            assert (info[i].m >= 0 && info[i].m <= 6 && info[i].nub >= 0 && info[i].nub <= info[i].m);
            if (info[i].m > 0) {
                joint[i] = joint[j];
                ++i;
            }
            ++j;
        }
        return i;
    }

    protected int createRowOffsetArray(int jcount, Joint.Info1[] info, int[] ofs) {
        int m = 0;
        int i = 0;
        while (i < jcount) {
            ofs[i] = m;
            m += info[i].m;
            ++i;
        }
        return m;
    }

    protected abstract void stepConstraints(int var1, World var2, Body[] var3, int var4, Joint[] var5, int var6, Joint.Info1[] var7, int[] var8, Matrix3[] var9, float var10, float var11);

    protected void updateVelocity(Body[] body, int bcount, Matrix3[] invI, float stepsize) {
        int i = 0;
        while (i < bcount) {
            body[i].getLinearVel(this.lvel);
            body[i].getAngularVel(this.avel);
            int j = 0;
            while (j < 3) {
                int n = j;
                this.lvel.m[n] = this.lvel.m[n] + stepsize * body[i].getMass().getInverseMass() * body[i].getFACC().m[j];
                ++j;
            }
            j = 0;
            while (j < 3) {
                int n = j++;
                body[i].getTACC().m[n] = body[i].getTACC().m[n] * stepsize;
            }
            MathUtils.dMULTIPLYADD0_331(this.avel, invI[i], body[i].getTACC());
            body[i].setLinearVel(this.lvel);
            body[i].setAngularVel(this.avel);
            ++i;
        }
    }

    protected void resetForces(Body[] body, int bcount) {
        int i = 0;
        while (i < bcount) {
            body[i].getFACC().setZero();
            body[i].getTACC().setZero();
            ++i;
        }
    }
}

