/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.util;

import net.java.dev.joode.util.Matrix2;
import net.java.dev.joode.util.ROVector2;
import net.java.dev.joode.util.Vector2;

public strictfp final class Math2D {
    private Math2D() {
    }

    public static Vector2 scale(ROVector2 a, float scale) {
        Vector2 temp = new Vector2(a);
        temp.scale(scale);
        return temp;
    }

    public static void sub(ROVector2 a, ROVector2 b, Vector2 passback) {
        passback.set(a);
        passback.sub(b);
    }

    public static float sign(float x) {
        return x < 0.0f ? -1.0f : 1.0f;
    }

    public static Vector2 mul(Matrix2 A, ROVector2 v) {
        return new Vector2(A.col1.x * v.getX() + A.col2.x * v.getY(), A.col1.y * v.getX() + A.col2.y * v.getY());
    }

    public static Matrix2 mul(Matrix2 A, Matrix2 B) {
        return new Matrix2(Math2D.mul(A, B.col1), Math2D.mul(A, B.col2));
    }

    public static Matrix2 abs(Matrix2 A) {
        return new Matrix2(Math2D.abs(A.col1), Math2D.abs(A.col2));
    }

    public static Vector2 abs(Vector2 a) {
        return new Vector2(Math.abs(a.x), Math.abs(a.y));
    }

    public static Matrix2 add(Matrix2 A, Matrix2 B) {
        Vector2 temp1 = new Vector2(A.col1);
        temp1.add(B.col1);
        Vector2 temp2 = new Vector2(A.col2);
        temp2.add(B.col2);
        return new Matrix2(temp1, temp2);
    }

    public static float cross(Vector2 a, Vector2 b) {
        return a.x * b.y - a.y * b.x;
    }

    public static Vector2 cross(float s, Vector2 a) {
        return new Vector2(-s * a.y, s * a.x);
    }

    public static Vector2 cross(Vector2 a, float s) {
        return new Vector2(s * a.y, -s * a.x);
    }

    public static float clamp(float a, float low, float high) {
        return Math.max(low, Math.min(a, high));
    }

    public static Vector2 getNormal(ROVector2 x, ROVector2 y) {
        Vector2 normal = new Vector2(y);
        normal.sub(x);
        normal = new Vector2(normal.y, -normal.x);
        normal.normalise();
        return normal;
    }

    public static float dot(float[] A, float[] B) {
        return A[0] * B[0] + A[1] * B[1];
    }

    public static float cross(float[] A, float[] B) {
        return A[0] * B[1] - A[1] * B[0];
    }

    public static void add(float[] A, float[] B, float[] res) {
        res[0] = A[0] + B[0];
        res[1] = A[1] + B[1];
    }

    public static void sub(float[] A, float[] B, float[] res) {
        res[0] = A[0] - B[0];
        res[1] = A[1] - B[1];
    }

    public static void mul(float[] A, float scalar) {
        A[0] = A[0] * scalar;
        A[1] = A[1] * scalar;
    }

    public static float norm(float[] A) {
        return (float)Math.sqrt(A[0] * A[0] + A[1] * A[1]);
    }

    public static void normalize(float[] A) {
        Math2D.mul(A, 1.0f / Math2D.norm(A));
    }
}

