/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.util;

import net.java.dev.joode.util.FastMath;
import net.java.dev.joode.util.Matrix3;
import net.java.dev.joode.util.Pool;
import net.java.dev.joode.util.Real;
import net.java.dev.joode.util.Vector3;
import net.java.dev.joode.util.Vector4;

public class Quaternion
extends Vector4 {
    public static final Pool<Quaternion> pool = new Pool<Quaternion>(){

        @Override
        protected Quaternion constuct() {
            return new Quaternion();
        }

        @Override
        protected void reset(Quaternion object) {
            object.m[0] = 1.0f;
            object.m[1] = 0.0f;
            object.m[2] = 0.0f;
            object.m[3] = 0.0f;
        }
    };
    private static final Vector3 tmpV = new Vector3();
    private static final Vector3 tmpVa = new Vector3();
    public static final Vector4 n1 = new Vector4();
    public static final Vector4 n2 = new Vector4();
    public static final Vector4 n3 = new Vector4();
    public static final Vector4 c1 = new Vector4();
    public static final Vector4 c2 = new Vector4();
    public static final Vector4 c3 = new Vector4();
    public static final Vector4 r1 = new Vector4();
    public static final Vector4 r2 = new Vector4();
    public static final Vector4 r3 = new Vector4();
    private static final Quaternion tmp = new Quaternion();
    private static final Quaternion tx = new Quaternion();
    private static final Quaternion ty = new Quaternion();
    private static final Quaternion tz = new Quaternion();
    private static final Quaternion start_copy = new Quaternion();

    public Quaternion() {
        this.m[0] = 1.0f;
    }

    public Quaternion(float s, float vx, float vy, float vz) {
        this.m[0] = s;
        this.m[1] = vx;
        this.m[2] = vy;
        this.m[3] = vz;
        this.normalize();
    }

    public Quaternion(Quaternion q) {
        int i = 0;
        while (i < 4) {
            this.m[i] = q.m[i];
            ++i;
        }
    }

    public void set(Matrix3 R) {
        float tr = R.get(0, 0) + R.get(1, 1) + R.get(2, 2);
        if (tr >= 0.0f) {
            float s = (float)Math.sqrt(tr + 1.0f);
            this.m[0] = 0.5f * s;
            s = 0.5f / s;
            this.m[1] = (R.get(1, 2) - R.get(2, 1)) * s;
            this.m[2] = (R.get(2, 0) - R.get(0, 2)) * s;
            this.m[3] = (R.get(0, 1) - R.get(1, 0)) * s;
        } else {
            int c = 0;
            if (R.get(1, 1) > R.get(0, 0)) {
                c = R.get(2, 2) > R.get(1, 1) ? 2 : 1;
            }
            if (R.get(2, 2) > R.get(0, 0)) {
                c = 2;
            }
            switch (c) {
                case 0: {
                    float s = (float)Math.sqrt(R.get(0, 0) - (R.get(1, 1) + R.get(2, 2)) + 1.0f);
                    this.m[1] = 0.5f * s;
                    s = 0.5f / s;
                    this.m[2] = (R.get(1, 0) + R.get(0, 1)) * s;
                    this.m[3] = (R.get(0, 2) + R.get(2, 0)) * s;
                    this.m[0] = (R.get(1, 2) - R.get(2, 1)) * s;
                    break;
                }
                case 1: {
                    float s = (float)Math.sqrt(R.get(1, 1) - (R.get(2, 2) + R.get(0, 0)) + 1.0f);
                    this.m[2] = 0.5f * s;
                    s = 0.5f / s;
                    this.m[3] = (R.get(2, 1) + R.get(1, 2)) * s;
                    this.m[1] = (R.get(1, 0) + R.get(0, 1)) * s;
                    this.m[0] = (R.get(2, 0) - R.get(0, 2)) * s;
                    break;
                }
                case 2: {
                    float s = (float)Math.sqrt(R.get(2, 2) - (R.get(0, 0) + R.get(1, 1)) + 1.0f);
                    this.m[3] = 0.5f * s;
                    s = 0.5f / s;
                    this.m[1] = (R.get(0, 2) + R.get(2, 0)) * s;
                    this.m[2] = (R.get(2, 1) + R.get(1, 2)) * s;
                    this.m[0] = (R.get(0, 1) - R.get(1, 0)) * s;
                }
            }
        }
    }

    public void toMatrix(Matrix3 R) {
        float qq1 = 2.0f * this.m[1] * this.m[1];
        float qq2 = 2.0f * this.m[2] * this.m[2];
        float qq3 = 2.0f * this.m[3] * this.m[3];
        R.m[0] = 1.0f - qq2 - qq3;
        R.m[1] = 2.0f * (this.m[1] * this.m[2] - this.m[0] * this.m[3]);
        R.m[2] = 2.0f * (this.m[1] * this.m[3] + this.m[0] * this.m[2]);
        R.m[4] = 2.0f * (this.m[1] * this.m[2] + this.m[0] * this.m[3]);
        R.m[5] = 1.0f - qq1 - qq3;
        R.m[6] = 2.0f * (this.m[2] * this.m[3] - this.m[0] * this.m[1]);
        R.m[8] = 2.0f * (this.m[1] * this.m[3] - this.m[0] * this.m[2]);
        R.m[9] = 2.0f * (this.m[2] * this.m[3] + this.m[0] * this.m[1]);
        R.m[10] = 1.0f - qq1 - qq2;
    }

    public static Quaternion setRandomQuation(Quaternion q) {
        int i = 0;
        while (i < 4) {
            q.m[i] = (float)Math.random();
            ++i;
        }
        q.normalize();
        return q;
    }

    public Quaternion mul(Quaternion q, Quaternion result) {
        assert (result.m != this.m);
        assert (result.m != q.m);
        result.m[0] = this.m[0] * q.m[0] - this.m[1] * q.m[1] - this.m[2] * q.m[2] - this.m[3] * q.m[3];
        result.m[1] = this.m[0] * q.m[1] + this.m[1] * q.m[0] + this.m[2] * q.m[3] - this.m[3] * q.m[2];
        result.m[2] = this.m[0] * q.m[2] - this.m[1] * q.m[3] + this.m[2] * q.m[0] + this.m[3] * q.m[1];
        result.m[3] = this.m[0] * q.m[3] + this.m[1] * q.m[2] - this.m[2] * q.m[1] + this.m[3] * q.m[0];
        return result;
    }

    public Quaternion mulScale(Vector3 v, float scale) {
        return this.mulScale(v, scale, new Quaternion());
    }

    public Quaternion mulScale(Vector3 v, float scale, Quaternion result) {
        Quaternion dq = result;
        dq.m[0] = scale * (-v.m[0] * this.m[1] - v.m[1] * this.m[2] - v.m[2] * this.m[3]);
        dq.m[1] = scale * (v.m[0] * this.m[0] + v.m[1] * this.m[3] - v.m[2] * this.m[2]);
        dq.m[2] = scale * (-v.m[0] * this.m[3] + v.m[1] * this.m[0] + v.m[2] * this.m[1]);
        dq.m[3] = scale * (v.m[0] * this.m[2] - v.m[1] * this.m[1] + v.m[2] * this.m[0]);
        return dq;
    }

    public static Vector3 invMulScale(Quaternion q, float scale, Quaternion result, Vector3 passback) {
        tx.set(q);
        tx.invert();
        result.mul(tx, tmp);
        int i = 0;
        while (i < 3) {
            passback.m[i] = Quaternion.tmp.m[i + 1] / scale;
            ++i;
        }
        return passback;
    }

    public Vector3 rotate(Vector3 v, Vector3 result) {
        Quaternion tmp = pool.aquire();
        Quaternion vq = pool.aquire();
        vq.set(0.0f, v.m[0], v.m[1], v.m[2]);
        Quaternion invZ = pool.aquire();
        invZ.set(this.m[0], -this.m[1], -this.m[2], -this.m[3]);
        this.mul(vq, tmp);
        tmp.mul(invZ, vq);
        result.set(vq.m[1], vq.m[2], vq.m[3]);
        pool.release(tmp);
        pool.release(vq);
        pool.release(invZ);
        return result;
    }

    public void setAxisAngle(float angle, Vector3 axis) {
        float cos_a;
        float sin_a = (float)Math.sin(angle / 2.0f);
        this.m[0] = cos_a = (float)Math.cos(angle / 2.0f);
        this.m[1] = axis.m[0] * sin_a;
        this.m[2] = axis.m[1] * sin_a;
        this.m[3] = axis.m[2] * sin_a;
        this.normalize();
    }

    public void setEuler(Vector3 v) {
        this.setEuler(v.m[0], v.m[1], v.m[2]);
    }

    public void setEuler(float ax, float ay, float az) {
        float sx = (float)Math.sin(ax / 2.0f);
        float cx = (float)Math.cos(ax / 2.0f);
        float sy = (float)Math.sin(ay / 2.0f);
        float cy = (float)Math.cos(ay / 2.0f);
        float sz = (float)Math.sin(az / 2.0f);
        float cz = (float)Math.cos(az / 2.0f);
        this.m[0] = cx * cy * cz + sx * sy * sz;
        this.m[1] = sx * cy * cz - cx * sy * sz;
        this.m[2] = cx * sy * cz + sx * cy * sz;
        this.m[3] = cx * cy * sz - sx * sy * cz;
    }

    public Vector3 getEuler(Vector3 passback) {
        passback.m[0] = (float)Math.atan(2.0f * (this.m[0] * this.m[1] + this.m[2] * this.m[3]) / (1.0f - 2.0f * (this.m[1] * this.m[1] + this.m[2] * this.m[2])));
        passback.m[1] = (float)Math.asin(2.0f * (this.m[0] * this.m[2] - this.m[3] * this.m[1]));
        passback.m[2] = (float)Math.atan(2.0f * (this.m[0] * this.m[3] + this.m[1] * this.m[2]) / (1.0f - 2.0f * (this.m[2] * this.m[2] + this.m[3] * this.m[3])));
        return passback;
    }

    public static float interpolateSLERP(Vector4 q1, Vector4 q2, float amount, Vector4 result) {
        float dotProduct = q1.dot(q2);
        if (Real.epsilonEquals(dotProduct, 1.0f, 1.0E-5f) || Real.epsilonEquals(dotProduct, -1.0f, 1.0E-5f)) {
            result.set(q1);
            return 0.0f;
        }
        if (amount == 0.0f) {
            result.set(q1);
            return 0.0f;
        }
        if (dotProduct < 0.0f) {
            dotProduct = -dotProduct;
            q1.scale(-1.0f);
        }
        if (amount == 1.0f) {
            result.set(q2);
            return FastMath.acos(dotProduct);
        }
        float omega = FastMath.acos(dotProduct);
        float sinOmega = (float)Math.sin(omega);
        float sinTOmega = (float)Math.sin(omega * amount);
        float sin1minusTOmega = (float)Math.sin(omega * (1.0f - amount));
        tmp.set(q1);
        tmp.scale(sin1minusTOmega / sinOmega);
        result.set(q2);
        result.scale(sinTOmega / sinOmega);
        result.add(tmp);
        assert ((double)omega < Math.PI && (double)omega > -Math.PI);
        return omega;
    }

    public static Quaternion weightedSLERP(Quaternion start, Quaternion target, Vector3 rotationAxis1, Vector3 rotationAxis2, Vector3 rotationAxis3, Vector3 weights, Vector3 anglePassback, Quaternion result) {
        start_copy.set(start);
        float dotProduct = start_copy.dot(target);
        if (Real.epsilonEquals(dotProduct, 1.0f, 1.0E-5f) || Real.epsilonEquals(dotProduct, -1.0f, 1.0E-5f)) {
            if (anglePassback != null) {
                anglePassback.setZero();
            }
            result.set(target);
            return result;
        }
        if (dotProduct < 0.0f) {
            dotProduct = -dotProduct;
            start_copy.scale(-1.0f);
        }
        assert (Quaternion.epsilonEquals(rotationAxis1.norm(), 1.0f, 1.0E-4f));
        assert (Quaternion.epsilonEquals(rotationAxis2.norm(), 1.0f, 1.0E-4f));
        assert (Quaternion.epsilonEquals(rotationAxis3.norm(), 1.0f, 1.0E-4f));
        start_copy.getDirection(rotationAxis1, n1);
        start_copy.getDirection(rotationAxis2, n2);
        start_copy.getDirection(rotationAxis3, n3);
        assert (Quaternion.epsilonEquals(n1.norm(), 1.0f, 1.0E-4f));
        assert (Quaternion.epsilonEquals(n2.norm(), 1.0f, 1.0E-4f));
        assert (Quaternion.epsilonEquals(n3.norm(), 1.0f, 1.0E-4f));
        Vector4.getLinearHyperPlaneNormal(n2, n3, target, c1);
        Vector4.getLinearHyperPlaneNormal(n1, n3, target, c2);
        Vector4.getLinearHyperPlaneNormal(n1, n2, target, c3);
        assert (Quaternion.epsilonEquals(c1.norm(), 1.0f, 1.0E-4f));
        assert (Quaternion.epsilonEquals(c2.norm(), 1.0f, 1.0E-4f));
        assert (Quaternion.epsilonEquals(c3.norm(), 1.0f, 1.0E-4f));
        if (anglePassback != null) {
            anglePassback.m[0] = Quaternion.interpolateSLERP(n1, c1, weights.m[0], r1) / 2.0f;
            anglePassback.m[1] = Quaternion.interpolateSLERP(n2, c2, weights.m[1], r2) / 2.0f;
            anglePassback.m[2] = Quaternion.interpolateSLERP(n3, c3, weights.m[2], r3) / 2.0f;
            tmp.set(target);
            tmp.sub(start_copy);
            start_copy.dqdt(rotationAxis1, tx);
            start_copy.dqdt(rotationAxis2, ty);
            start_copy.dqdt(rotationAxis3, tz);
            if (tx.dot(tmp) < 0.0f) {
                anglePassback.m[0] = -anglePassback.m[0];
            }
            if (ty.dot(tmp) < 0.0f) {
                anglePassback.m[1] = -anglePassback.m[1];
            }
            if (tz.dot(tmp) < 0.0f) {
                anglePassback.m[2] = -anglePassback.m[2];
            }
        } else {
            Quaternion.interpolateSLERP(n1, c1, weights.m[0], r1);
            Quaternion.interpolateSLERP(n2, c2, weights.m[1], r2);
            Quaternion.interpolateSLERP(n3, c3, weights.m[2], r3);
        }
        Vector4.getLinearHyperPlaneNormal(r1, r2, r3, result);
        assert (Quaternion.epsilonEquals(result.dot(r1), 0.0f, 1.0E-4f));
        assert (Quaternion.epsilonEquals(result.dot(r2), 0.0f, 1.0E-4f));
        assert (Quaternion.epsilonEquals(result.dot(r3), 0.0f, 1.0E-4f));
        result.normalize();
        assert (Quaternion.epsilonEquals(result.dot(r1), 0.0f, 1.0E-4f));
        assert (Quaternion.epsilonEquals(result.dot(r2), 0.0f, 1.0E-4f));
        assert (Quaternion.epsilonEquals(result.dot(r3), 0.0f, 1.0E-4f));
        return result;
    }

    public static void getAngles(Quaternion q1, Quaternion q2, Vector3 rotationAxis1, Vector3 rotationAxis2, Vector3 rotationAxis3, Vector3 passback) {
        float angle3;
        Vector4 d1 = Vector4.pool.aquire();
        Vector4 d2 = Vector4.pool.aquire();
        Vector4 d3 = Vector4.pool.aquire();
        Quaternion target = pool.aquire();
        target.set(q2);
        if (q2.dot(q1) < 0.0f) {
            target.scale(-1.0f);
        }
        q1.getDirection(rotationAxis1, d1);
        q1.getDirection(rotationAxis2, d2);
        q1.getDirection(rotationAxis3, d3);
        float distCommon = target.dot(q1);
        Vector4 common = Vector4.pool.aquire();
        common.set(q1);
        common.scale(distCommon);
        float dist1 = target.dot(d1);
        float dist2 = target.dot(d2);
        float dist3 = target.dot(d3);
        d1.scale(dist1);
        d2.scale(dist2);
        d3.scale(dist3);
        d1.add(common);
        d2.add(common);
        d3.add(common);
        d1.normalize();
        d2.normalize();
        d3.normalize();
        float angle1 = Vector4.epsilonEquals(q1, d1, 1.0E-5f) ? 0.0f : FastMath.acos(d1.dot(q1));
        float angle2 = Vector4.epsilonEquals(q1, d2, 1.0E-5f) ? 0.0f : FastMath.acos(d2.dot(q1));
        float f = angle3 = Vector4.epsilonEquals(q1, d3, 1.0E-5f) ? 0.0f : FastMath.acos(d3.dot(q1));
        if (Float.isNaN(angle1)) {
            angle1 = 0.0f;
        } else if (dist1 < 0.0f) {
            angle1 = -angle1;
        }
        if (Float.isNaN(angle2)) {
            angle2 = 0.0f;
        } else if (dist2 < 0.0f) {
            angle2 = -angle2;
        }
        if (Float.isNaN(angle3)) {
            angle3 = 0.0f;
        } else if (dist3 < 0.0f) {
            angle3 = -angle3;
        }
        passback.set(angle1 / 2.0f, angle2 / 2.0f, angle3 / 2.0f);
        pool.release(target);
        Vector4.pool.release(common);
        Vector4.pool.release(d1);
        Vector4.pool.release(d2);
        Vector4.pool.release(d3);
    }

    public void getDirection(Vector3 rotationAxix, Vector4 passbackNormal) {
        int i = 0;
        while (i < 3) {
            Quaternion.tmpV.m[i] = this.m[i + 1];
            ++i;
        }
        passbackNormal.m[0] = -tmpV.dot(rotationAxix);
        tmpV.cross(rotationAxix, tmpVa);
        i = 0;
        while (i < 3) {
            passbackNormal.m[i + 1] = Quaternion.tmpVa.m[i] + this.m[0] * rotationAxix.m[i];
            ++i;
        }
        passbackNormal.normalize();
    }

    public void dqdt(Vector3 angularVelocity, Quaternion passback) {
        this.mulScale(angularVelocity, 0.5f, passback);
    }

    public void invert() {
        float d = this.lengthSquared();
        if (d == 0.0f) {
            return;
        }
        this.m[0] = this.m[0] / d;
        this.m[1] = -this.m[1] / d;
        this.m[2] = -this.m[2] / d;
        this.m[3] = -this.m[3] / d;
    }

    public static boolean epsilonEquals(Quaternion a, Quaternion b, float e) {
        boolean elementsTheSame = true;
        int i = 0;
        while (i < 4) {
            if (!(a.m[i] + e > b.m[i]) || !(a.m[i] - e < b.m[i])) {
                elementsTheSame = false;
            }
            ++i;
        }
        if (elementsTheSame) {
            return true;
        }
        i = 0;
        while (i < 4) {
            if (!(a.m[i] + e > -b.m[i]) || !(a.m[i] - e < -b.m[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public float getNorm() {
        return this.m[0] * this.m[0] + this.m[1] * this.m[1] + this.m[2] * this.m[2] + this.m[3] * this.m[3];
    }
}

