/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.util;

import java.util.Arrays;
import net.java.dev.joode.util.JOODELog;
import net.java.dev.joode.util.Pool1D;
import net.java.dev.joode.util.RealPointer;
import net.java.dev.joode.util.Vector;

public class Real
implements Vector {
    public static final Pool1D<Real> pool = new Pool1D<Real>(){

        @Override
        protected Real construct(int index) {
            return new Real(index);
        }

        @Override
        protected int getIndex(Real real) {
            return real.size();
        }

        @Override
        protected void reset(Real real) {
            real.setZero();
        }
    };
    public final float[] m;

    @Deprecated
    public Real(int size) {
        this.m = new float[size];
    }

    @Deprecated
    public Real(float[] array) {
        this.m = array;
    }

    public int size() {
        return this.m.length;
    }

    public float get(int index) {
        return this.m[index];
    }

    public void set(Vector vector) {
        int i = 0;
        while (i < vector.size()) {
            this.m[i] = vector.get(i);
            ++i;
        }
    }

    public void set(Real other) {
        System.arraycopy(other.m, 0, this.m, 0, this.m.length);
    }

    public void setZero() {
        Arrays.fill(this.m, 0.0f);
    }

    public void fill(float value) {
        Arrays.fill(this.m, value);
    }

    public Real add(Real a) {
        assert (this.size() == a.size()) : "the size of the vectors has to be equal";
        int i = 0;
        while (i < this.m.length) {
            int n = i;
            this.m[n] = this.m[n] + a.m[i];
            ++i;
        }
        return this;
    }

    public Real sub(Real a) {
        assert (this.size() == a.size()) : "the size of the vectors has to be equal";
        int i = 0;
        while (i < this.m.length) {
            int n = i;
            this.m[n] = this.m[n] - a.m[i];
            ++i;
        }
        return this;
    }

    public void scale(float scale) {
        int i = 0;
        while (i < this.size()) {
            int n = i++;
            this.m[n] = this.m[n] * scale;
        }
    }

    public float dot(Real a) {
        float d = 0.0f;
        int i = 0;
        while (i < this.size()) {
            d += this.m[i] * a.m[i];
            ++i;
        }
        return d;
    }

    public float dot(RealPointer a) {
        float d = 0.0f;
        int i = 0;
        while (i < this.size()) {
            d += this.m[i] * a.getValue(i);
            ++i;
        }
        return d;
    }

    public float norm() {
        float l = 0.0f;
        int i = 0;
        while (i < this.m.length) {
            l += this.m[i] * this.m[i];
            ++i;
        }
        if (l > 0.0f) {
            return (float)Math.sqrt(l);
        }
        JOODELog.debug("vector has zero size");
        return 0.0f;
    }

    public void normalize() {
        float l = 0.0f;
        int i = 0;
        while (i < this.m.length) {
            l += this.m[i] * this.m[i];
            ++i;
        }
        if (l > 0.0f) {
            l = 1.0f / (float)Math.sqrt(l);
            this.scale(l);
        } else {
            JOODELog.error("vector has zero size");
        }
    }

    public void negate() {
        int i = 0;
        while (i < this.m.length) {
            int n = i++;
            this.m[n] = this.m[n] * -1.0f;
        }
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.dot(this);
    }

    public float min() {
        float min = Float.MAX_VALUE;
        int i = 0;
        while (i < this.size()) {
            min = Math.min(this.m[i], min);
            ++i;
        }
        return min;
    }

    public float max() {
        float max = Float.MIN_VALUE;
        int i = 0;
        while (i < this.size()) {
            max = Math.max(this.m[i], max);
            ++i;
        }
        return max;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < this.size()) {
            ret.append(this.m[i]).append(" ");
            ++i;
        }
        return ret.toString();
    }

    public static boolean epsilonEquals(Real a, Real b, float e) {
        if (a.size() != b.size()) {
            return false;
        }
        int i = 0;
        while (i < a.size()) {
            if (!(a.m[i] + e > b.m[i]) || !(a.m[i] - e < b.m[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void set(int index, float value) {
        this.m[index] = value;
    }

    public static boolean epsilonEquals(float a, float b, float e) {
        return a + e > b && a - e < b;
    }
}

