/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.joode.util;

import net.java.dev.joode.util.Matrix;
import net.java.dev.joode.util.Matrix4;
import net.java.dev.joode.util.Pool;
import net.java.dev.joode.util.Real;

public class Vector4
extends Real {
    public static final Pool<Vector4> pool = new Pool<Vector4>(){

        @Override
        protected Vector4 constuct() {
            return new Vector4();
        }

        @Override
        protected void reset(Vector4 object) {
            object.setZero();
        }
    };
    public static final Matrix4 modifiedNormals = new Matrix4();
    public static final Matrix4 tmp = new Matrix4();
    public static final Matrix4 linearHyperplaneCooeffecients = new Matrix4();
    public static final Vector4 linearHyperplaneRHS = new Vector4(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Vector4 additionalConstraint = new Vector4(1.0f, 1.0f, 1.0f, 1.0f);

    public Vector4() {
        super(4);
    }

    public Vector4(float a, float b, float c, float d) {
        super(4);
        this.set(a, b, c, d);
    }

    public static Vector4 aquire(float x, float y, float z, float d) {
        Vector4 v = pool.aquire();
        v.set(x, y, z, d);
        return v;
    }

    public void release() {
        pool.release(this);
    }

    public void set(float a, float b, float c, float d) {
        this.m[0] = a;
        this.m[1] = b;
        this.m[2] = c;
        this.m[3] = d;
    }

    public void add(float a, float b, float c, float d) {
        this.m[0] = this.m[0] + a;
        this.m[1] = this.m[1] + b;
        this.m[2] = this.m[2] + c;
        this.m[3] = this.m[3] + d;
    }

    public void sub(float a, float b, float c, float d) {
        this.m[0] = this.m[0] - a;
        this.m[1] = this.m[1] - b;
        this.m[2] = this.m[2] - c;
        this.m[3] = this.m[3] - d;
    }

    public String toString() {
        return "(" + this.m[0] + ", " + this.m[1] + ", " + this.m[2] + ", " + this.m[3] + ")";
    }

    public static Vector4 getLinearHyperPlaneNormal(Vector4 p1, Vector4 p2, Vector4 p3, Vector4 normal) {
        Matrix A = Matrix.pool.aquire(3, 3);
        Real B = Real.pool.aquire(3);
        Real tmp = Real.pool.aquire(3);
        A.set(0, 0, p1.get(0));
        A.set(1, 0, p1.get(1));
        A.set(2, 0, p1.get(2));
        A.set(0, 1, p2.get(0));
        A.set(1, 1, p2.get(1));
        A.set(2, 1, p2.get(2));
        A.set(0, 2, p3.get(0));
        A.set(1, 2, p3.get(1));
        A.set(2, 2, p3.get(2));
        B.set(0, p1.get(3));
        B.set(1, p2.get(3));
        B.set(2, p3.get(3));
        int minus1Assumption = 3;
        int i = 0;
        while (i < 4) {
            if (Matrix.solve(A, B, normal)) break;
            tmp.set(B);
            if (--minus1Assumption == -1) break;
            A.getColumn(minus1Assumption, B);
            A.setColumn(minus1Assumption, tmp);
            ++i;
        }
        if (minus1Assumption == -1) {
            normal.fill(Float.NaN);
        } else {
            i = 3;
            while (i > minus1Assumption) {
                normal.m[i] = normal.m[i - 1];
                --i;
            }
            normal.m[minus1Assumption] = -1.0f;
            normal.scale(-1.0f);
            normal.normalize();
        }
        Matrix.pool.release(A);
        Real.pool.release(B);
        Real.pool.release(tmp);
        return normal;
    }

    public static Vector4 setRandomVector(Vector4 normal) {
        int i = 0;
        while (i < 4) {
            normal.m[i] = (float)Math.random();
            ++i;
        }
        normal.normalize();
        return normal;
    }
}

