/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.commands;

import java.util.ArrayList;
import java.util.HashMap;
import org.jagatoo.commands.Command;
import org.jagatoo.commands.CommandException;
import org.jagatoo.input.devices.components.ControllerAxis;
import org.jagatoo.input.devices.components.ControllerButton;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.devices.components.Key;
import org.jagatoo.input.devices.components.MouseButton;
import org.jagatoo.input.events.ControllerAxisChangedEvent;
import org.jagatoo.input.events.ControllerButtonEvent;
import org.jagatoo.input.events.ControllerButtonPressedEvent;
import org.jagatoo.input.events.ControllerButtonReleasedEvent;
import org.jagatoo.input.events.KeyPressedEvent;
import org.jagatoo.input.events.KeyReleasedEvent;
import org.jagatoo.input.events.KeyStateEvent;
import org.jagatoo.input.events.KeyTypedEvent;
import org.jagatoo.input.events.MouseButtonClickedEvent;
import org.jagatoo.input.events.MouseButtonEvent;
import org.jagatoo.input.events.MouseButtonPressedEvent;
import org.jagatoo.input.events.MouseButtonReleasedEvent;
import org.jagatoo.input.events.MouseMovedEvent;
import org.jagatoo.input.events.MouseStoppedEvent;
import org.jagatoo.input.events.MouseWheelEvent;
import org.jagatoo.input.listeners.InputListener;
import org.jagatoo.logging.Log;
import org.jagatoo.logging.LogChannel;

class CommandDispatcher
implements InputListener {
    private final LogChannel logChannel;
    private final HashMap<DeviceComponent, ArrayList<Command>> bindings = new HashMap();

    public void bindCommand(DeviceComponent comp, Command command) {
        ArrayList<Command> commands = this.bindings.get(comp);
        if (commands == null) {
            commands = new ArrayList();
            this.bindings.put(comp, commands);
        }
        if (!commands.contains(command)) {
            commands.add(command);
        }
    }

    public void unbindCommand(DeviceComponent comp, Command command) {
        ArrayList<Command> commands = this.bindings.get(comp);
        if (commands == null) {
            commands = new ArrayList();
            this.bindings.put(comp, commands);
        }
        if (!commands.contains(command)) {
            commands.add(command);
        }
    }

    public void unbindAll() {
        this.bindings.clear();
    }

    public final void executeCommand(Command command, Boolean inputInfo, Object[] parameters) {
        try {
            String result = command.execute(inputInfo, parameters);
            if (result != null) {
                Log.println(this.logChannel, 0, new Object[]{result});
            }
        }
        catch (CommandException ex) {
            Log.println(this.logChannel, 0, new Object[]{ex.getMessage()});
        }
        catch (Throwable ex) {
            Log.print(this.logChannel, ex);
        }
    }

    private final void processInputEvent(Boolean inputInfo, DeviceComponent comp) {
        ArrayList<Command> commands = this.bindings.get(comp);
        if (commands != null) {
            int i = 0;
            while (i < commands.size()) {
                this.executeCommand(commands.get(i), inputInfo, null);
                ++i;
            }
        }
    }

    public void onKeyPressed(KeyPressedEvent e, Key key) {
        this.processInputEvent(Boolean.TRUE, key);
    }

    public void onKeyReleased(KeyReleasedEvent e, Key key) {
        this.processInputEvent(Boolean.FALSE, key);
    }

    public void onKeyStateChanged(KeyStateEvent e, Key key, boolean state) {
    }

    public void onKeyTyped(KeyTypedEvent e, char keyChar) {
    }

    public void onMouseButtonPressed(MouseButtonPressedEvent e, MouseButton button) {
        this.processInputEvent(Boolean.TRUE, button);
    }

    public void onMouseButtonReleased(MouseButtonReleasedEvent e, MouseButton button) {
        this.processInputEvent(Boolean.FALSE, button);
    }

    public void onMouseButtonClicked(MouseButtonClickedEvent e, MouseButton button, int clickCount) {
    }

    public void onMouseButtonStateChanged(MouseButtonEvent e, MouseButton button, boolean state) {
    }

    public void onMouseMoved(MouseMovedEvent e, int x, int y, int dx, int dy) {
    }

    public void onMouseWheelMoved(MouseWheelEvent e, int wheelDelta) {
    }

    public long getMouseStopDelay() {
        return 500000000L;
    }

    public void onMouseStopped(MouseStoppedEvent e, int x, int y) {
    }

    public void onControllerButtonPressed(ControllerButtonPressedEvent e, ControllerButton button) {
        this.processInputEvent(Boolean.TRUE, button);
    }

    public void onControllerButtonReleased(ControllerButtonReleasedEvent e, ControllerButton button) {
        this.processInputEvent(Boolean.FALSE, button);
    }

    public void onControllerButtonStateChanged(ControllerButtonEvent e, ControllerButton button, boolean state) {
    }

    public void onControllerAxisChanged(ControllerAxisChangedEvent e, ControllerAxis axis, float axisDelta) {
    }

    public CommandDispatcher(LogChannel logChannel) {
        if (logChannel == null) {
            throw new NullPointerException("logChannel must not be null");
        }
        this.logChannel = logChannel;
    }
}

