/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.commands;

import java.util.HashMap;
import java.util.List;
import org.jagatoo.commands.Command;
import org.jagatoo.commands.CommandDispatcher;
import org.jagatoo.commands.CommandLine;
import org.jagatoo.commands.InputActionCommand;
import org.jagatoo.input.devices.components.DeviceComponent;
import org.jagatoo.input.listeners.InputListener;
import org.jagatoo.input.managers.InputBindingsManager;
import org.jagatoo.input.managers.InputBindingsSet;
import org.jagatoo.logging.Log;
import org.jagatoo.logging.LogChannel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandProcessor {
    private final LogChannel logChannel;
    private final HashMap<String, Command> availableCommandsMap = new HashMap();
    private Command[] availableCommands;
    private final CommandLine commandLine = new CommandLine();
    private final CommandDispatcher dispatcher;

    public final LogChannel getLogChannel() {
        return this.logChannel;
    }

    public Command[] getRegisteredCommands() {
        return this.availableCommands;
    }

    public Command getRegisteredCommand(String key) {
        return this.availableCommandsMap.get(key);
    }

    public final InputListener getInputListener() {
        return this.dispatcher;
    }

    public final Command registerCommand(Command command) {
        if (!this.availableCommandsMap.containsKey(command.getKey())) {
            this.availableCommandsMap.put(command.getKey(), command);
            Command[] newArray = new Command[this.availableCommands.length + 1];
            System.arraycopy(this.availableCommands, 0, newArray, 0, this.availableCommands.length);
            newArray[newArray.length - 1] = command;
            this.availableCommands = newArray;
        }
        return command;
    }

    public final void registerCommands(List<? extends Command> commands) {
        int i = 0;
        while (i < commands.size()) {
            this.registerCommand(commands.get(i));
            ++i;
        }
    }

    public final void registerCommands(Command[] commands) {
        int i = 0;
        while (i < commands.length) {
            this.registerCommand(commands[i]);
            ++i;
        }
    }

    public void bindCommand(DeviceComponent comp, InputActionCommand command) {
        this.dispatcher.bindCommand(comp, command);
    }

    public <C extends InputActionCommand> void bindCommands(InputBindingsManager<C> bindingsManager) {
        for (InputActionCommand command : bindingsManager.getBoundActions()) {
            DeviceComponent comp = bindingsManager.getBoundComponent(command, InputBindingsSet.PRIMARY);
            if (comp != null) {
                this.bindCommand(comp, command);
            }
            if ((comp = bindingsManager.getBoundComponent(command, InputBindingsSet.SECONDARY)) == null) continue;
            this.bindCommand(comp, command);
        }
    }

    public void unbindCommand(DeviceComponent comp, InputActionCommand command) {
        this.dispatcher.unbindCommand(comp, command);
    }

    public void unbindAll() {
        this.dispatcher.unbindAll();
    }

    public void processLine(String line) {
        this.commandLine.parse(line);
        if (this.commandLine.getKey() != null) {
            Command command = this.availableCommandsMap.get(this.commandLine.getKey());
            Object[] params = command.createParametersArray(this.commandLine.getParameters());
            if (params != null) {
                this.dispatcher.executeCommand(command, null, params);
            } else {
                Log.exception(this.logChannel, "Invalid command invocation: " + line);
            }
        } else {
            Log.exception(this.logChannel, "Unknown command: " + line);
        }
    }

    public CommandProcessor(LogChannel logChannel) {
        if (logChannel == null) {
            throw new NullPointerException("logChannel must not be null");
        }
        this.logChannel = logChannel;
        this.dispatcher = new CommandDispatcher(logChannel);
        this.availableCommands = new Command[0];
    }

    public CommandProcessor(LogChannel logChannel, Command[] availableCommands) {
        this(logChannel);
        this.availableCommands = new Command[availableCommands.length];
        int i = 0;
        while (i < availableCommands.length) {
            this.availableCommandsMap.put(availableCommands[i].getKey(), availableCommands[i]);
            this.availableCommands[i] = availableCommands[i];
            ++i;
        }
    }

    public CommandProcessor(LogChannel logChannel, List<Command> availableCommands) {
        this(logChannel);
        this.availableCommands = new Command[availableCommands.size()];
        int i = 0;
        while (i < availableCommands.size()) {
            this.availableCommandsMap.put(availableCommands.get(i).getKey(), availableCommands.get(i));
            this.availableCommands[i] = availableCommands.get(i);
            ++i;
        }
    }
}

