/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.geometry;

import java.nio.FloatBuffer;
import org.jagatoo.geometry.GeomNioData;
import org.jagatoo.util.nio.BufferUtils;
import org.openmali.vecmath2.Colorf;
import org.openmali.vecmath2.TexCoordf;
import org.openmali.vecmath2.TupleNf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeomNioFloatData
extends GeomNioData {
    protected FloatBuffer buffer;
    private final int floatStride;

    public final void setBuffer(FloatBuffer buffer) {
        this.buffer = buffer;
    }

    public final FloatBuffer getBuffer() {
        return this.buffer;
    }

    public final int getElemStride() {
        if (this.floatStride == 0) {
            return this.getElemSize();
        }
        return this.floatStride;
    }

    public final float[] getData() {
        float[] f = new float[this.buffer.limit()];
        this.buffer.rewind();
        this.buffer.get(f);
        return f;
    }

    public final void getData(float[] outBuffer) {
        this.buffer.rewind();
        this.buffer.get(outBuffer);
    }

    public final void getData(int index, long elemOffset, float[] outBuffer, int start, int length) {
        this.buffer.position(index * this.getElemStride() + (int)elemOffset);
        this.buffer.get(outBuffer, 0, length);
    }

    @Override
    public final void start() {
        this.buffer.clear();
        this.setDirty(true);
    }

    public final void end() {
    }

    public final void set(float[] a, int start, int length) {
        this.buffer.put(a, start, length);
        this.setDirty(true);
    }

    public final void set(float x) {
        this.buffer.put(x);
        this.setDirty(true);
    }

    public final void set(float x, float y) {
        this.buffer.put(x);
        this.buffer.put(y);
        this.setDirty(true);
    }

    public final void set(float x, float y, float z) {
        this.buffer.put(x);
        this.buffer.put(y);
        this.buffer.put(z);
        this.setDirty(true);
    }

    public final void set(float x, float y, float z, float w) {
        this.buffer.put(x);
        this.buffer.put(y);
        this.buffer.put(z);
        this.buffer.put(w);
        this.setDirty(true);
    }

    public final void set(int index, int elemSize, long elemOffset, float[] a, int start, int length) {
        int pos = index * this.getElemStride() + (int)elemOffset;
        int i = 0;
        while (i < length) {
            this.buffer.position(pos);
            this.buffer.put(a, start + i, elemSize);
            pos += this.getElemStride();
            i += elemSize;
        }
        this.setDirty(true);
    }

    public final void set(int index, int elemSize, long elemOffset, float[] a) {
        this.set(index, elemSize, elemOffset, a, 0, a.length);
    }

    public final void set(int index, long elemOffset, float x) {
        this.buffer.position(index * this.getElemStride() + (int)elemOffset);
        this.buffer.put(x);
        this.setDirty(true);
    }

    public final void set(int index, long elemOffset, float x, float y) {
        this.buffer.position(index * this.getElemStride() + (int)elemOffset);
        this.buffer.put(x);
        this.buffer.put(y);
        this.setDirty(true);
    }

    public final void set(int index, long elemOffset, float x, float y, float z) {
        this.buffer.position(index * this.getElemStride() + (int)elemOffset);
        this.buffer.put(x);
        this.buffer.put(y);
        this.buffer.put(z);
        this.setDirty(true);
    }

    public final void set(int index, long elemOffset, float x, float y, float z, float w) {
        this.buffer.position(index * this.getElemStride() + (int)elemOffset);
        this.buffer.put(x);
        this.buffer.put(y);
        this.buffer.put(z);
        this.buffer.put(w);
        this.setDirty(true);
    }

    public final void get(int index, int elemSize, long elemOffset, float[] values, int offset, int numValues) {
        int pos = index * this.getElemStride() + (int)elemOffset;
        int i = 0;
        while (i < numValues) {
            this.buffer.position(pos);
            this.buffer.get(values, offset + i, elemSize);
            pos += this.getElemStride();
            i += elemSize;
        }
    }

    public final void get(int index, int elemSize, long elemOffset, float[] values) {
        this.get(index, elemSize, elemOffset, values, 0, values.length);
    }

    public final float get(int index, long elemOffset) {
        this.buffer.position(index * this.getElemStride() + (int)elemOffset);
        return this.buffer.get();
    }

    public final void set(TupleNf<?> tuple) {
        tuple.writeToBuffer(this.buffer, false, false);
        this.setDirty(true);
    }

    public final void set(boolean alpha, Colorf color) {
        this.buffer.put(color.getRed());
        this.buffer.put(color.getGreen());
        this.buffer.put(color.getBlue());
        if (alpha) {
            this.buffer.put(color.getAlpha());
        }
        this.setDirty(true);
    }

    public final void set(TexCoordf<?> texCoord) {
        texCoord.writeToBuffer(this.buffer, false, false);
        this.setDirty(true);
    }

    public final void set(int index, long elemOffset, TupleNf<?> tuple) {
        this.buffer.position(index * this.getElemStride() + (int)elemOffset);
        tuple.writeToBuffer(this.buffer, false, false);
        this.setDirty(true);
    }

    public final void set(int index, int elemSize, long elemOffset, Colorf color) {
        this.buffer.position(index * this.getElemStride() + (int)elemOffset);
        this.buffer.put(color.getRed());
        this.buffer.put(color.getGreen());
        this.buffer.put(color.getBlue());
        if (elemSize == 4) {
            this.buffer.put(color.getAlpha());
        }
        this.setDirty(true);
    }

    public final void set(int index, long elemOffset, TexCoordf<?> texCoord) {
        this.buffer.position(index * this.getElemStride() + (int)elemOffset);
        texCoord.writeToBuffer(this.buffer, false, false);
        this.setDirty(true);
    }

    public final void get(int index, long elemOffset, TupleNf<?> values) {
        this.buffer.position(index * this.getElemStride() + (int)elemOffset);
        values.readFromBuffer(this.buffer);
    }

    public final void get(int index, int elemSize, long elemOffset, Colorf color) {
        this.buffer.position(index * this.getElemStride() + (int)elemOffset);
        color.setRed(this.buffer.get());
        color.setGreen(this.buffer.get());
        color.setBlue(this.buffer.get());
        if (elemSize == 4) {
            color.setAlpha(this.buffer.get());
        }
    }

    public final void get(int index, long elemOffset, TexCoordf<?> texCoord) {
        this.buffer.position(index * this.getElemStride() + (int)elemOffset);
        texCoord.readFromBuffer(this.buffer);
    }

    protected GeomNioFloatData newInstance(int maxElements, int elemSize, int stride, boolean reversed) {
        return new GeomNioFloatData(maxElements, elemSize, stride, reversed);
    }

    public GeomNioFloatData duplicateGeomData(boolean copy) {
        GeomNioFloatData data = this.newInstance(this.getMaxElements(), this.getElemSize(), this.getStride(), this.isReversed());
        if (copy) {
            data.buffer.clear();
            this.buffer.rewind();
            data.buffer.put(this.buffer);
            data.buffer.rewind();
            this.buffer.rewind();
        }
        return data;
    }

    public GeomNioFloatData(int maxElements, int elemSize, int stride, boolean reversed) {
        super(maxElements, maxElements * elemSize, elemSize, stride, reversed);
        this.floatStride = stride / 4;
        this.buffer = BufferUtils.createFloatBuffer(maxElements * elemSize);
    }

    public GeomNioFloatData(int maxElements, int elemSize, boolean reversed) {
        this(maxElements, elemSize, 0, reversed);
    }
}

