/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.input.events;

import org.jagatoo.input.InputSystem;
import org.jagatoo.input.events.ControllerEvent;
import org.jagatoo.input.events.InputEvent;
import org.jagatoo.input.events.KeyboardEvent;
import org.jagatoo.input.events.MouseEvent;
import org.jagatoo.input.render.InputSourceWindow;

public class EventQueue {
    public static final Object LOCK = new Object();
    private InputEvent[] events = new InputEvent[128];
    private int numEvents = 0;
    private boolean hasNullEvents = false;

    public final int getNumEvents() {
        return this.numEvents;
    }

    public final InputEvent getEvent(int index) {
        return this.events[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueue(InputEvent event) {
        Object object = LOCK;
        synchronized (object) {
            if (this.numEvents == this.events.length - 1) {
                InputEvent[] tmp = new InputEvent[(int)((double)this.numEvents * 1.5) + 1];
                System.arraycopy(this.events, 0, tmp, 0, this.numEvents);
                this.events = tmp;
            }
            this.events[this.numEvents++] = event;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dequeueAndFire(InputSystem inputSystem, InputEvent.Type filteredType) {
        Object object = LOCK;
        synchronized (object) {
            if (this.numEvents == 0) {
                return;
            }
            int i = 0;
            while (i < this.numEvents) {
                InputEvent event = this.events[i];
                if (event != null && (filteredType == null || filteredType == event.getType())) {
                    switch (event.getType()) {
                        case KEYBOARD_EVENT: {
                            KeyboardEvent kbEvent = (KeyboardEvent)event;
                            kbEvent.getKeyboard().fireKeyboardEvent(kbEvent, true);
                            break;
                        }
                        case MOUSE_EVENT: {
                            MouseEvent moEvent = (MouseEvent)event;
                            moEvent.getMouse().fireMouseEvent(moEvent, true);
                            break;
                        }
                        case CONTROLLER_EVENT: {
                            ControllerEvent ctEvent = (ControllerEvent)event;
                            ctEvent.getController().fireControllerEvent(ctEvent, true);
                        }
                    }
                    if (filteredType != null) {
                        this.events[i] = null;
                        this.hasNullEvents = true;
                    }
                }
                ++i;
            }
            if (filteredType == null) {
                this.numEvents = 0;
            } else {
                this.strip();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void strip() {
        Object object = LOCK;
        synchronized (object) {
            if (!this.hasNullEvents || this.numEvents == 0) {
                return;
            }
            int offset = 0;
            int i = 0;
            while (i < this.numEvents) {
                if (this.events[i] == null) {
                    ++offset;
                } else if (offset != 0) {
                    this.events[i - offset] = this.events[i];
                }
                ++i;
            }
            i = this.numEvents - offset;
            while (i < this.numEvents) {
                this.events[i] = null;
                ++i;
            }
            this.numEvents -= offset;
            this.hasNullEvents = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(InputSourceWindow sourceWindow) {
        Object object = LOCK;
        synchronized (object) {
            if (sourceWindow == null) {
                int i = 0;
                while (i < this.events.length) {
                    this.events[i] = null;
                    this.numEvents = 0;
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this.events.length) {
                    if (this.events[i] != null) {
                        switch (this.events[i].getType()) {
                            case KEYBOARD_EVENT: {
                                if (((KeyboardEvent)this.events[i]).getKeyboard().getSourceWindow() != sourceWindow) break;
                                this.events[i] = null;
                                break;
                            }
                            case MOUSE_EVENT: {
                                if (((MouseEvent)this.events[i]).getMouse().getSourceWindow() != sourceWindow) break;
                                this.events[i] = null;
                                break;
                            }
                            case CONTROLLER_EVENT: {
                                if (((ControllerEvent)this.events[i]).getController().getSourceWindow() != sourceWindow) break;
                                this.events[i] = null;
                            }
                        }
                    }
                    ++i;
                }
                this.strip();
            }
        }
    }
}

